/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.util;

import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.internal.ServiceHolder;

public class IUPropertyUtils {
    private static Log log = LogFactory.getLog(IUPropertyUtils.class);
    static final Locale DEFAULT_LOCALE = new Locale("df", "LT");
    static final String NAMESPACE_IU_LOCALIZATION = "org.eclipse.equinox.p2.localization";
    private static Map<Locale, SoftReference<Collection>> LocaleCollectionCache = new HashMap<Locale, SoftReference<Collection>>(2);

    public static ILicense getLicense(IInstallableUnit iu) throws URISyntaxException {
        return IUPropertyUtils.getLicense(iu, DEFAULT_LOCALE);
    }

    public static ICopyright getCopyright(IInstallableUnit iu) {
        return IUPropertyUtils.getCopyright(iu, DEFAULT_LOCALE);
    }

    public static String getIUProperty(IInstallableUnit iu, String propertyKey) {
        return IUPropertyUtils.getIUProperty(iu, propertyKey, DEFAULT_LOCALE);
    }

    public static ILicense getLicense(IInstallableUnit iu, Locale locale) throws URISyntaxException {
        ILicense iLicense = null;
        Collection licenses = iu.getLicenses();
        if (licenses.size() != 0) {
            ILicense lic;
            String body;
            ILicense[] licenseArray = licenses.toArray(new ILicense[licenses.size()]);
            ILicense license = licenseArray[0];
            String string = body = license != null ? license.getBody() : null;
            if (body == null || body.length() <= 1 || body.charAt(0) != '%') {
                return license;
            }
            String actualKey = body.substring(1);
            if ((body = IUPropertyUtils.getLocalizedIUProperty(iu, actualKey, locale)) == null) {
                return null;
            }
            iLicense = lic = MetadataFactory.createLicense((URI)license.getLocation(), (String)body);
        }
        return iLicense;
    }

    public static ICopyright getCopyright(IInstallableUnit iu, Locale locale) {
        String body;
        ICopyright copyright = iu.getCopyright();
        String string = body = copyright != null ? copyright.getBody() : null;
        if (body == null || body.length() <= 1 || body.charAt(0) != '%') {
            return copyright;
        }
        String actualKey = body.substring(1);
        body = IUPropertyUtils.getLocalizedIUProperty(iu, actualKey, locale);
        return MetadataFactory.createCopyright((URI)copyright.getLocation(), (String)body);
    }

    public static String getIUProperty(IInstallableUnit iu, String propertyKey, Locale locale) {
        String value = iu.getProperty(propertyKey);
        if (value == null || value.length() <= 1 || value.charAt(0) != '%') {
            return value;
        }
        String actualKey = value.substring(1);
        return IUPropertyUtils.getLocalizedIUProperty(iu, actualKey, locale);
    }

    private static String getLocalizedIUProperty(IInstallableUnit iu, String actualKey, Locale locale) {
        String localizedKey = IUPropertyUtils.makeLocalizedKey(actualKey, locale.toString());
        return iu.getProperty(localizedKey, locale.toString());
    }

    private static String cacheResult(IInstallableUnit iu, String localizedKey, String localizedValue) {
        if (iu instanceof InstallableUnit) {
            ((InstallableUnit)iu).setLocalizedProperty(localizedKey, localizedValue);
        }
        return localizedValue;
    }

    private static synchronized Collection getLocalizationFragments(Locale locale, List localeVariants) {
        Collection cached;
        SoftReference<Collection> collectorRef = LocaleCollectionCache.get(locale);
        if (collectorRef != null && (cached = collectorRef.get()) != null) {
            return cached;
        }
        final List locales = localeVariants;
        Collector localeFragmentCollector = new Collector(){

            public boolean accept(Object object) {
                boolean haveLocale = false;
                if (object instanceof IInstallableUnitFragment) {
                    IInstallableUnitFragment fragment = (IInstallableUnitFragment)object;
                    Collection providedCapabilities = fragment.getProvidedCapabilities();
                    block0: for (IProvidedCapability providedCapability : providedCapabilities) {
                        String providedLocale;
                        IProvidedCapability nextProvide = providedCapability;
                        if (!IUPropertyUtils.NAMESPACE_IU_LOCALIZATION.equals(nextProvide.getNamespace()) || (providedLocale = nextProvide.getName()) == null) continue;
                        Iterator iter = locales.iterator();
                        while (iter.hasNext()) {
                            if (!providedLocale.equals(iter.next())) continue;
                            haveLocale = true;
                            continue block0;
                        }
                    }
                }
                return haveLocale ? super.accept(object) : true;
            }
        };
        IProfileRegistry profileRegistry = null;
        try {
            profileRegistry = ServiceHolder.getProfileRegistry();
        }
        catch (ProvisioningException e) {
            log.warn((Object)"Profile registry unavailable. Default language will be used.");
            return Collections.emptySet();
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            log.warn((Object)"Profile unavailable. Default language will be used.");
            return Collections.emptySet();
        }
        Set collection = profile.query(QueryUtil.createIUPropertyQuery((String)"org.eclipse.equinox.p2.type.fragment", (String)"true"), null).toUnmodifiableSet();
        LocaleCollectionCache.put(locale, new SoftReference<Set>(collection));
        return collection;
    }

    private static List buildLocaleVariants(Locale locale) {
        String nl = locale.toString();
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            result.add(nl);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(DEFAULT_LOCALE.toString());
        return result;
    }

    private static String makeLocalizedKey(String actualKey, String localeImage) {
        return localeImage + '.' + actualKey;
    }

    private static Locale getCurrentLocale() {
        return Locale.getDefault();
    }
}

