/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.coyote.http11.upgrade.UpgradeAprProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProtocol
extends AbstractHttp11Protocol {
    private static final Log log = LogFactory.getLog(Http11AprProtocol.class);
    private final Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11AprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler((AprEndpoint.Handler)this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public boolean getUseSendfile() {
        return ((AprEndpoint)this.endpoint).getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        ((AprEndpoint)this.endpoint).setUseSendfile(useSendfile);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int pollTime) {
        ((AprEndpoint)this.endpoint).setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setMaxConnections(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    public void setPollerThreadCount(int pollerThreadCount) {
        ((AprEndpoint)this.endpoint).setPollerThreadCount(pollerThreadCount);
    }

    public int getPollerThreadCount() {
        return ((AprEndpoint)this.endpoint).getPollerThreadCount();
    }

    public int getSendfileSize() {
        return ((AprEndpoint)this.endpoint).getSendfileSize();
    }

    public void setSendfileSize(int sendfileSize) {
        ((AprEndpoint)this.endpoint).setSendfileSize(sendfileSize);
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        ((AprEndpoint)this.endpoint).setSendfileThreadCount(sendfileThreadCount);
    }

    public int getSendfileThreadCount() {
        return ((AprEndpoint)this.endpoint).getSendfileThreadCount();
    }

    public boolean getDeferAccept() {
        return ((AprEndpoint)this.endpoint).getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        ((AprEndpoint)this.endpoint).setDeferAccept(deferAccept);
    }

    public String getSSLProtocol() {
        return ((AprEndpoint)this.endpoint).getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        ((AprEndpoint)this.endpoint).setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return ((AprEndpoint)this.endpoint).getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        ((AprEndpoint)this.endpoint).setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return ((AprEndpoint)this.endpoint).getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        ((AprEndpoint)this.endpoint).setSSLCipherSuite(SSLCipherSuite);
    }

    public String getSSLCertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        ((AprEndpoint)this.endpoint).setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        ((AprEndpoint)this.endpoint).setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        ((AprEndpoint)this.endpoint).setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        ((AprEndpoint)this.endpoint).setSSLVerifyDepth(SSLVerifyDepth);
    }

    @Override
    protected String getNamePrefix() {
        return "http-apr";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<Long, Http11AprProcessor>
    implements AprEndpoint.Handler {
        protected Http11AprProtocol proto;

        Http11ConnectionHandler(Http11AprProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public void release(SocketWrapper<Long> socket, Processor<Long> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.offer(processor);
            if (addToPoller && this.proto.endpoint.isRunning()) {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(((Long)socket.getSocket()).longValue(), true);
            }
        }

        @Override
        protected void initSsl(SocketWrapper<Long> socket, Processor<Long> processor) {
        }

        @Override
        protected void longPoll(SocketWrapper<Long> socket, Processor<Long> processor) {
            this.connections.put(socket.getSocket(), processor);
            if (processor.isAsync()) {
                socket.setAsync(true);
            } else if (processor.isComet() && this.proto.endpoint.isRunning()) {
                ((AprEndpoint)this.proto.endpoint).getCometPoller().add(((Long)socket.getSocket()).longValue(), false);
            } else {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(((Long)socket.getSocket()).longValue(), false);
            }
        }

        @Override
        protected Http11AprProcessor createProcessor() {
            Http11AprProcessor processor = new Http11AprProcessor(this.proto.getMaxHttpHeaderSize(), (AprEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize());
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setConnectionUploadTimeout(this.proto.getConnectionUploadTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }

        @Override
        protected Processor<Long> createUpgradeProcessor(SocketWrapper<Long> socket, UpgradeInbound inbound) throws IOException {
            return new UpgradeAprProcessor(socket, inbound);
        }
    }
}

