/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.stratos.identity.saml2.sso.mgt;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.sso.saml.SSOServiceProviderConfigManager;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.stratos.identity.saml2.sso.mgt.internal.StratosSSOMgtServiceComponent;

public class SSOServiceProviderUpdateManager {
    private static Log log = LogFactory.getLog(SSOServiceProviderUpdateManager.class);

    public void addServiceProviders() {
        SAMLSSOServiceProviderDO[] serviceProviders = this.readServiceProvidersFromFile();
        if (serviceProviders != null) {
            SSOServiceProviderConfigManager configManager = StratosSSOMgtServiceComponent.getSSOServiceProviderConfigManager();
            for (SAMLSSOServiceProviderDO spDO : serviceProviders) {
                configManager.addServiceProvider(spDO.getIssuer(), spDO);
                log.info((Object)("A SSO Service Provider is registered for : " + spDO.getIssuer()));
            }
        }
    }

    private SAMLSSOServiceProviderDO[] readServiceProvidersFromFile() {
        Document document = null;
        try {
            String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "sso-idp-config.xml";
            if (!this.isFileExisting(configFilePath)) {
                log.warn((Object)"sso-idp-config.xml does not exist in the 'conf' directory. The system maydepend on the service providers added through the UI.");
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(configFilePath);
        }
        catch (Exception e) {
            log.error((Object)"Error reading Service Providers from sso-idp-config.xml", (Throwable)e);
            return null;
        }
        Element element = document.getDocumentElement();
        NodeList nodeSet = element.getElementsByTagName("ServiceProvider");
        SAMLSSOServiceProviderDO[] serviceProviders = new SAMLSSOServiceProviderDO[nodeSet.getLength()];
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            Element elem = (Element)nodeSet.item(i);
            SAMLSSOServiceProviderDO spDO = new SAMLSSOServiceProviderDO();
            spDO.setIssuer(this.getTextValue(elem, "Issuer"));
            spDO.setAssertionConsumerUrl(this.getTextValue(elem, "AssertionConsumerService"));
            spDO.setLoginPageURL(this.getTextValue(elem, "CustomLoginPage"));
            spDO.setUseFullyQualifiedUsername(true);
            spDO.setDoSingleLogout(true);
            spDO.setDoSignAssertions(true);
            serviceProviders[i] = spDO;
        }
        return serviceProviders;
    }

    private String getTextValue(Element element, String tagName) {
        String textVal = null;
        NodeList nl = element.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    private boolean isFileExisting(String path) {
        File file = new File(path);
        return file.exists();
    }
}

