/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.stratos.identity.saml2.sso.mgt.ui;

import java.io.File;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.core.model.SAMLSSOServiceProviderDO;
import org.wso2.carbon.identity.sso.saml.SSOServiceProviderConfigManager;
import org.wso2.carbon.utils.CarbonUtils;

public class Util {
    private static final String TENANT_REGISTRATION_PAGE = "TenantRegistrationPage";
    private static final String BANNER_ADDS_BASE_URL = "LoginPageBannerBaseURL";
    private static String loginPageBannerBaseURL;
    private static String tenantRegistrationPageURL;
    private static SSOServiceProviderConfigManager ssoServiceProviderConfigManager;
    private static Log log;

    public static void setSsoServiceProviderConfigManager(SSOServiceProviderConfigManager ssoServiceProviderConfigManager) {
        Util.ssoServiceProviderConfigManager = ssoServiceProviderConfigManager;
    }

    public static String getStratosServiceName(String requestPath) {
        String context = Util.calculateWebContextFromContextPath(requestPath);
        String stratosServiceName = null;
        Enumeration serviceProviders = ssoServiceProviderConfigManager.getAllServiceProviders();
        while (serviceProviders.hasMoreElements()) {
            SAMLSSOServiceProviderDO serviceProvider = (SAMLSSOServiceProviderDO)serviceProviders.nextElement();
            if (!context.equals(serviceProvider.getLoginPageURL())) continue;
            stratosServiceName = serviceProvider.getIssuer();
            break;
        }
        return Util.base64Encode(stratosServiceName);
    }

    public static void populateLoginPageConfigParams() {
        NodeList bannerAddBaseURLNodeSet;
        Document document = null;
        try {
            String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "sso-idp-config.xml";
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(configFilePath);
        }
        catch (Exception e) {
            log.error((Object)"Error reading Service Providers from sso-idp-config.xml", (Throwable)e);
        }
        Element element = document.getDocumentElement();
        NodeList tenantRegNodeSet = element.getElementsByTagName(TENANT_REGISTRATION_PAGE);
        if (tenantRegNodeSet.getLength() > 0) {
            Element elem = (Element)tenantRegNodeSet.item(0);
            tenantRegistrationPageURL = elem.getFirstChild().getNodeValue();
        }
        if ((bannerAddBaseURLNodeSet = element.getElementsByTagName(BANNER_ADDS_BASE_URL)).getLength() > 0) {
            Element elem = (Element)bannerAddBaseURLNodeSet.item(0);
            loginPageBannerBaseURL = elem.getFirstChild().getNodeValue();
        }
    }

    public static String getTenantRegistrationPageURL() {
        return tenantRegistrationPageURL;
    }

    public static String getBannerAddsBaseURL() {
        return loginPageBannerBaseURL;
    }

    private static String calculateWebContextFromContextPath(String requestPath) {
        requestPath = requestPath.replace("//", "/");
        String subStr = ((Object)requestPath.subSequence(0, requestPath.lastIndexOf("/"))).toString();
        String context = ((Object)requestPath.subSequence(subStr.lastIndexOf("/") + 1, requestPath.length())).toString();
        return context.trim();
    }

    private static String base64Encode(String plainTxt) {
        if (plainTxt != null) {
            return Base64.encode((byte[])plainTxt.getBytes());
        }
        return null;
    }

    public static String getForgetPasswordLink() {
        String registerPageURL = Util.getTenantRegistrationPageURL();
        return registerPageURL.replace("select_domain.jsp", "../admin-mgt/forgot_password.jsp");
    }

    static {
        log = LogFactory.getLog(Util.class);
    }
}

