/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dnsserverregistration.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.dnsserverregistration.ui.bean.ServiceDiscoveryBean;

public class ServiceDiscovery {
    private static Log log = LogFactory.getLog(ServiceDiscovery.class);

    public void discoverServices() {
        Logger logger = Logger.getLogger(JmDNS.class.getName());
        ConsoleHandler handler = new ConsoleHandler();
        logger.addHandler(handler);
        logger.setLevel(Level.FINER);
        handler.setLevel(Level.FINER);
        try {
            JmDNS jmdns = JmDNS.create();
            jmdns.addServiceListener("_wso2server._tcp.local.", (ServiceListener)new serviceListener());
        }
        catch (Exception e) {
            log.error((Object)"Could not discover the services", (Throwable)e);
        }
    }

    public ServiceDiscoveryBean listwso2Services() {
        ArrayList<String> serviceList = new ArrayList<String>();
        ArrayList<String> urlList = new ArrayList<String>();
        try {
            JmDNS jmdns = JmDNS.create();
            ServiceDiscoveryBean jmdnsBean = new ServiceDiscoveryBean();
            ServiceInfo[] infos = jmdns.list("_wso2server._tcp.local.");
            while (infos.length == 0) {
                try {
                    infos = jmdns.list("_wso2server._tcp.local.");
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Could not retrive server list", (Throwable)e);
                }
            }
            for (int i = 0; i < infos.length; ++i) {
                serviceList.add(infos[i].getName());
                urlList.add(infos[i].getURL("https"));
            }
            jmdnsBean.setServicesToAdd(serviceList);
            jmdnsBean.setURLOfTheServer(urlList);
            return jmdnsBean;
        }
        catch (IOException e) {
            log.error((Object)"Could not list the available servers", (Throwable)e);
            return null;
        }
    }

    class serviceListener
    implements ServiceListener {
        serviceListener() {
        }

        public void serviceAdded(ServiceEvent event) {
            event.getDNS().requestServiceInfo(event.getType(), event.getName());
            System.out.println("Service added   : " + event.getName() + "." + event.getType());
        }

        public void serviceRemoved(ServiceEvent event) {
            System.out.println("Service removed : " + event.getName() + "." + event.getType());
        }

        public void serviceResolved(ServiceEvent event) {
            System.out.println("Service resolved: " + event.getInfo());
        }
    }
}

