/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.resource.DiscoverResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.components.crypto.X509NameTokenizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.InvalidReason;
import org.wso2.xkms2.KRSSRequest;
import org.wso2.xkms2.KRSSResult;
import org.wso2.xkms2.KeyBinding;
import org.wso2.xkms2.KeyBindingAbstractType;
import org.wso2.xkms2.KeyUsage;
import org.wso2.xkms2.LocateRequest;
import org.wso2.xkms2.LocateResult;
import org.wso2.xkms2.MessageAbstractType;
import org.wso2.xkms2.PrivateKey;
import org.wso2.xkms2.PrototypeKeyBinding;
import org.wso2.xkms2.QueryKeyBinding;
import org.wso2.xkms2.RecoverKeyBinding;
import org.wso2.xkms2.RecoverRequest;
import org.wso2.xkms2.RecoverResult;
import org.wso2.xkms2.RegisterRequest;
import org.wso2.xkms2.RegisterResult;
import org.wso2.xkms2.ReissueKeyBinding;
import org.wso2.xkms2.ReissueRequest;
import org.wso2.xkms2.ReissueResult;
import org.wso2.xkms2.RequestAbstractType;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.ResultMajor;
import org.wso2.xkms2.ResultMinor;
import org.wso2.xkms2.ResultType;
import org.wso2.xkms2.Status;
import org.wso2.xkms2.StatusValue;
import org.wso2.xkms2.UnverifiedKeyBinding;
import org.wso2.xkms2.UseKeyWith;
import org.wso2.xkms2.ValidReason;
import org.wso2.xkms2.ValidateRequest;
import org.wso2.xkms2.ValidateResult;
import org.wso2.xkms2.ValidityInterval;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.core.XKMSRequestData;
import org.wso2.xkms2.util.XKMSKeyUtil;
import org.wso2.xkms2.util.XKMSUtil;

public class XKMSServerCrypto {
    private static final Log LOG = LogFactory.getLog((String)XKMSServerCrypto.class.getName());
    public static final String XKMS_SERVER_AUTHENTICATION_CODE = "org.wso2.xkms2.service.crypto.authen.code";
    public static final String XKMS_KEY_STORE_LOCATION = "org.wso2.xkms2.service.crypto.keystore.location";
    public static final String XKMS_KEY_STORE_PASSWORD = "org.wso2.xkms2.service.crypto.keystore.password";
    public static final String XKMS_SERVER_CERT_ALIACE = "org.wso2.xkms2.service.crypto.server.cert.aliase";
    public static final String XKMS_SERVER_KEY_PASSWORD = "org.wso2.xkms2.service.crypto.server.key.password";
    public static final String XKMS_ISSUER_CERT_ALIACE = "org.wso2.xkms2.service.crypto.issuer.cert.aliase";
    public static final String XKMS_ISSUER_KEY_PASSWORD = "org.wso2.xkms2.service.crypto.issuer.key.password";
    public static final String XKMS_DEFAULT_EXPIRY_INTERVAL = "org.wso2.xkms2.service.crypto.default.expriy.interval";
    public static final String XKMS_DEFAULT_PRIVATE_KEY_PASSWORD = "org.wso2.xkms2.service.crypto.default.private.key.password";
    public static final String XKMS_ENABLE_PERSISTENCE = "org.wso2.xkms2.service.crypto.persistence.enabled";
    public static final String PROP_ID_CERT_PROVIDER = "org.wso2.xkms2.service.crypto.cert.provider";
    static String SKI_OID = "2.5.29.14";
    private static CertificateFactory certFact;
    private KeyStore keystore = null;
    protected KeyStore cacerts = null;
    private X509Certificate cacert = null;
    private java.security.PrivateKey cakey = null;
    private java.security.PrivateKey sekey = null;
    private Key authkey = null;
    private Key enkey = null;
    private Date caexpiry = null;
    private int validityPeriod;
    private Properties properties;
    private ClassLoader classLoader;
    private boolean canSupportPersistence = false;
    private boolean saveKeystore = false;
    private Document doc;

    public XKMSServerCrypto(Properties properties) throws XKMSException {
        this(properties, XKMSServerCrypto.class.getClassLoader());
    }

    public XKMSServerCrypto(Properties properties, ClassLoader classLoader) throws XKMSException {
        this.properties = properties;
        this.classLoader = classLoader;
        this.Init();
    }

    private void Init() throws XKMSException {
        String passcode = this.properties.getProperty(XKMS_SERVER_AUTHENTICATION_CODE);
        if (passcode != null && passcode.length() > 0) {
            this.authkey = XKMSKeyUtil.getAuthenticationKey(passcode);
        }
        if ((passcode = this.properties.getProperty(XKMS_SERVER_AUTHENTICATION_CODE)) != null && passcode.length() > 0) {
            this.enkey = XKMSKeyUtil.getPrivateKey(passcode, "DESede");
        }
        this.loadKeyStore();
        String alias = this.properties.getProperty(XKMS_ISSUER_CERT_ALIACE);
        this.cacert = this.getCertificate(alias);
        this.caexpiry = this.cacert.getNotAfter();
        alias = this.properties.getProperty(XKMS_ISSUER_CERT_ALIACE);
        passcode = this.properties.getProperty(XKMS_ISSUER_KEY_PASSWORD);
        this.cakey = this.getPrivateKey(alias, passcode);
        alias = this.properties.getProperty(XKMS_SERVER_CERT_ALIACE);
        passcode = this.properties.getProperty(XKMS_SERVER_KEY_PASSWORD);
        this.sekey = this.getPrivateKey(alias, passcode);
        String noOfDays = this.properties.getProperty(XKMS_DEFAULT_EXPIRY_INTERVAL);
        this.validityPeriod = noOfDays != null ? Integer.parseInt(noOfDays) : 365;
        String persistence = this.properties.getProperty(XKMS_ENABLE_PERSISTENCE);
        this.saveKeystore = persistence != null ? Boolean.getBoolean(persistence) : false;
    }

    public ResultType process(XKMSRequestData data) throws AxisFault {
        RequestAbstractType request = data.getRequest();
        this.doc = data.getDocument();
        if (request instanceof RegisterRequest) {
            return this.handleRegisterRequest((RegisterRequest)request);
        }
        if (request instanceof ValidateRequest) {
            return this.handleValidateRequest((ValidateRequest)request);
        }
        if (request instanceof ReissueRequest) {
            return this.handleReissueRequest((ReissueRequest)request);
        }
        if (request instanceof LocateRequest) {
            return this.handleLocateRequest((LocateRequest)request);
        }
        if (request instanceof RecoverRequest) {
            return this.handleRecoverRequest((RecoverRequest)request);
        }
        return null;
    }

    public RegisterResult handleRegisterRequest(RegisterRequest request) {
        try {
            ValidityInterval validityInterval;
            this.prepare(request, request.getPrototypeKeyBinding());
            this.validate(request);
            PrototypeKeyBinding pkb = request.getPrototypeKeyBinding();
            String identifer = this.getSubjectDN(pkb);
            if (identifer == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No SubjectDN is specified");
                }
                throw new XKMSException(4, "NoSubjectDN");
            }
            PublicKey public1 = pkb.getKeyValue();
            java.security.PrivateKey private1 = null;
            if (public1 == null) {
                KeyPair keypair = XKMSKeyUtil.generateRSAKeyPair();
                public1 = keypair.getPublic();
                private1 = keypair.getPrivate();
            }
            Date[] adjustedInterval = (validityInterval = pkb.getValidityInterval()) != null ? this.getAdjustedValidityInterval(validityInterval.getNotBefore(), validityInterval.getOnOrAfter()) : this.getAdjustedValidityInterval((Date)null, (Date)null);
            long serialNum = this.nextSerialNumber();
            String aliase = this.createAlias(serialNum);
            BigInteger serialNumber = BigInteger.valueOf(serialNum);
            List keyUsage = pkb.getKeyUsage();
            X509Certificate cert = keyUsage == null || keyUsage.isEmpty() || keyUsage.size() == 1 && keyUsage.contains(KeyUsage.EXCHANGE) ? XKMSKeyUtil.getX509Certificate(identifer, serialNumber, adjustedInterval[0], adjustedInterval[1], public1, this.cacert, this.cakey) : XKMSKeyUtil.getX509Certificate(identifer, serialNumber, adjustedInterval[0], adjustedInterval[1], keyUsage.contains(KeyUsage.SIGNATURE), keyUsage.contains(KeyUsage.ENCRYPTION), public1, this.cacert, this.cakey);
            try {
                this.keystore.setCertificateEntry(aliase, cert);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding the newly constructed X509Certificate to the keystore - \n " + cert));
                }
                if (private1 != null) {
                    Certificate[] chain = new Certificate[]{cert};
                    this.keystore.setKeyEntry(aliase, private1, this.getPrivateKeyPassword(), chain);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Added the newly construct Private Key to the keystore - \n" + private1));
                    }
                }
                if (this.saveKeystore) {
                    this.saveKeystore();
                }
            }
            catch (KeyStoreException e) {
                LOG.error((Object)"Adding the certificate to keystore failed", (Throwable)e);
                throw new XKMSException(e);
            }
            RegisterResult result = XKMSUtil.createRegisterResult();
            this.buildResultType(request, result, aliase, this.keystore);
            return result;
        }
        catch (XKMSException ex) {
            RegisterResult resultType = XKMSUtil.createRegisterResult();
            this.buildFault(request, resultType, ex);
            return resultType;
        }
    }

    public ReissueResult handleReissueRequest(ReissueRequest request) {
        try {
            this.prepare(request, request.getReissueKeyBinding());
            this.validate(request);
            ReissueKeyBinding rkb = request.getReissueKeyBinding();
            X509Certificate cert = rkb.getCertValue();
            if (cert == null) {
                throw new XKMSException(4, "CertNotPresent");
            }
            String alias = this.getAliasForX509Cert(cert.getIssuerDN().getName(), cert.getSerialNumber());
            if (alias == null) {
                throw new XKMSException(4, "CertNotFound");
            }
            ReissueResult result = XKMSUtil.creatReissueResult();
            this.buildResultType(request, result, alias, this.keystore);
            return result;
        }
        catch (XKMSException ex) {
            ReissueResult result = XKMSUtil.creatReissueResult();
            this.buildFault(request, result, ex);
            return result;
        }
    }

    public RecoverResult handleRecoverRequest(RecoverRequest request) {
        try {
            String keyName;
            this.prepare(request, request.getRecoverKeyBinding());
            RecoverKeyBinding recoverKeyBinding = request.getRecoverKeyBinding();
            String[] aliases = null;
            X509Certificate cert = recoverKeyBinding.getCertValue();
            if (cert != null) {
                BigInteger serialNumber;
                String issuerDN = cert.getIssuerDN().getName();
                String alias = this.getAliasForX509Cert(issuerDN, serialNumber = cert.getSerialNumber());
                if (alias != null) {
                    aliases = new String[]{alias};
                }
            } else {
                String subjectDN = this.getSubjectDN(recoverKeyBinding);
                if (subjectDN != null) {
                    aliases = this.getAliasesForDN(subjectDN);
                }
            }
            if (aliases == null && (keyName = recoverKeyBinding.getKeyName()) != null) {
                aliases = new String[]{keyName};
            }
            if (aliases == null || aliases.length < 1) {
                throw new XKMSException(1, "keyNotFound");
            }
            RecoverResult recoverResult = XKMSUtil.createRecoverResult();
            this.buildResultType(request, recoverResult, aliases[0], this.keystore);
            return recoverResult;
        }
        catch (XKMSException ex) {
            RecoverResult recoverResult = XKMSUtil.createRecoverResult();
            this.buildFault(request, recoverResult, ex);
            return recoverResult;
        }
    }

    public LocateResult handleLocateRequest(LocateRequest locate) {
        try {
            String alias;
            QueryKeyBinding keybinding = locate.getQueryKeyBinding();
            String identifer = this.getSubjectDN(keybinding);
            String[] aliases = null;
            if (identifer == null) {
                KeyInfo keyInfo = keybinding.getKeyInfo();
                if (keyInfo != null) {
                    try {
                        KeyName keyName = keyInfo.itemKeyName(0);
                        if (keyName != null) {
                            aliases = new String[]{keyName.getKeyName()};
                        }
                    }
                    catch (XMLSecurityException xme) {
                        throw new XKMSException(xme);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No SubjectDN is specified");
                }
            } else {
                aliases = this.getAliasesForDN(identifer);
            }
            byte[] skiValue = this.getSKIValue(keybinding);
            if (skiValue != null && (alias = this.getAliasForX509Cert(skiValue)) != null) {
                aliases = new String[]{alias};
            }
            if (aliases == null || aliases.length == 0) {
                throw new XKMSException("KeyNotFound");
            }
            List keyUsage = keybinding.getKeyUsage();
            boolean digitalSigning = keyUsage.contains(KeyUsage.SIGNATURE);
            boolean dataEncryption = keyUsage.contains(KeyUsage.ENCRYPTION);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < aliases.length; ++i) {
                String alias2 = aliases[i];
                X509Certificate cert = this.getCertificate(alias2);
                if (cert == null) continue;
                boolean[] ku = cert.getKeyUsage();
                if (digitalSigning && !ku[0] || dataEncryption && !ku[3]) continue;
                list.add(alias2);
            }
            if (list.isEmpty()) {
                throw new XKMSException(1, "KeyNotFound");
            }
            LocateResult result = XKMSUtil.createLocateResult();
            this.buildResultType(locate, result);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String alias3 = (String)iterator.next();
                X509Certificate[] certs = this.getCertificates(alias3);
                UnverifiedKeyBinding ukb = new UnverifiedKeyBinding();
                this.addKeyInfo(locate.getRespondWith(), alias3, certs, ukb);
                this.addKeyUsage(certs[0], ukb);
                result.addUnverifiedKeyBinding(ukb);
            }
            return result;
        }
        catch (XKMSException ex) {
            LocateResult result = XKMSUtil.createLocateResult();
            this.buildFault(locate, result, ex);
            return result;
        }
    }

    public ValidateResult handleValidateRequest(ValidateRequest validateRequest) {
        try {
            QueryKeyBinding queryKeyBinding = validateRequest.getQueryKeyBinding();
            List respondWith = validateRequest.getRespondWith();
            KeyInfo keyInfo = queryKeyBinding.getKeyInfo();
            X509Certificate cert = null;
            if (keyInfo != null) {
                try {
                    cert = keyInfo.getX509Certificate();
                }
                catch (KeyResolverException e) {
                    throw new XKMSException(4, "keystore", e);
                }
            }
            if (cert == null) {
                throw new XKMSException(4, "CertNotPresent");
            }
            if (this.verifyTrust(cert)) {
                ValidateResult validateResult = XKMSUtil.createValidateResult();
                this.buildResultType(validateRequest, validateResult);
                String subjectDN = cert.getIssuerDN().getName();
                BigInteger issuerSerial = cert.getSerialNumber();
                String alias = this.getAliasForX509Cert(subjectDN, issuerSerial);
                X509Certificate[] certs = this.getCertificates(alias);
                KeyBinding keyBinding = XKMSUtil.createKeyBinding();
                validateResult.addKeyBinding(keyBinding);
                this.addKeyInfo(respondWith, alias, certs, keyBinding);
                this.addKeyUsage(certs[0], keyBinding);
                this.addStatus(true, keyBinding);
                return validateResult;
            }
            ValidateResult result = XKMSUtil.createValidateResult();
            this.buildResultType(validateRequest, result);
            KeyBinding keybinding = XKMSUtil.createKeyBinding();
            X509Certificate[] certs = new X509Certificate[]{cert};
            this.addKeyInfo(validateRequest.getRespondWith(), null, certs, keybinding);
            this.addKeyUsage(certs[0], keybinding);
            this.addStatus(false, keybinding);
            result.addKeyBinding(keybinding);
            return result;
        }
        catch (XKMSException ex) {
            ValidateResult resultType = XKMSUtil.createValidateResult();
            this.buildFault(validateRequest, resultType, ex);
            return resultType;
        }
    }

    private void prepare(KRSSRequest request, KeyBindingAbstractType abstractType) throws XKMSException {
        Authentication authentication = request.getAuthentication();
        authentication.setKeyBindingAuthenticationKey(this.authkey);
        KeyInfo keyInfo = abstractType.getKeyInfo();
        if (keyInfo != null) {
            try {
                X509Certificate cert;
                PublicKey public1;
                KeyName itemKeyName = keyInfo.itemKeyName(0);
                if (itemKeyName != null) {
                    abstractType.setKeyName(itemKeyName.getKeyName());
                }
                if ((public1 = keyInfo.getPublicKey()) != null) {
                    abstractType.setKeyValue(public1);
                }
                if ((cert = keyInfo.getX509Certificate()) != null) {
                    abstractType.setCertValue(cert);
                    abstractType.setKeyValue(cert.getPublicKey());
                }
            }
            catch (KeyResolverException e) {
                LOG.error((Object)"", (Throwable)e);
                throw new XKMSException(4, "noKey", e);
            }
            catch (XMLSecurityException e) {
                LOG.error((Object)"", (Throwable)e);
                throw new XKMSException(4, "noKey", e);
            }
        }
    }

    private void validate(ReissueRequest reissueRequest) throws XKMSException {
        X509Certificate cert;
        this.validate((KRSSRequest)reissueRequest);
        ReissueKeyBinding rkb = reissueRequest.getReissueKeyBinding();
        XMLSignature pop = reissueRequest.getProofOfPocession();
        PublicKey key = rkb.getKeyValue();
        if (key == null && (cert = rkb.getCertValue()) != null) {
            key = cert.getPublicKey();
        }
        if (pop != null && key != null) {
            try {
                pop.checkSignatureValue((Key)key);
            }
            catch (XMLSignatureException se) {
                throw new XKMSException("Proof-Of-Pocession varification failed", (Throwable)se);
            }
        }
    }

    private void validate(RegisterRequest registerRequest) throws XKMSException {
        this.validate((KRSSRequest)registerRequest);
        PrototypeKeyBinding pkb = registerRequest.getPrototypeKeyBinding();
        XMLSignature proofOfPossession = registerRequest.getProofOfPossession();
        PublicKey key = pkb.getKeyValue();
        if (key != null) {
            try {
                proofOfPossession.checkSignatureValue((Key)key);
            }
            catch (XMLSignatureException e) {
                LOG.error((Object)"", (Throwable)e);
                throw new XKMSException(12, "popRequired", e);
            }
        }
    }

    private void validate(KRSSRequest request) throws XKMSException {
        this.validate((MessageAbstractType)request);
        Authentication authentication = request.getAuthentication();
        XMLSignature keyBindingAuthentication = authentication.getKeyBindingAuthentication();
        Key keyBindingAuthenticationKey = authentication.getKeyBindingAuthenticationKey();
        try {
            if (!keyBindingAuthentication.checkSignatureValue(keyBindingAuthenticationKey)) {
                throw new XKMSException(6, "invalidXMLSign");
            }
            System.out.println("success");
        }
        catch (XMLSignatureException e) {
            LOG.error((Object)"", (Throwable)e);
            throw new XKMSException(6, "invalidXMLSign", e);
        }
    }

    private void validate(MessageAbstractType abstractType) throws XKMSException {
        XMLSignature signature = abstractType.getSignature();
        if (signature != null) {
            X509Certificate x509Certificate = abstractType.getSignCert();
            try {
                signature.checkSignatureValue(x509Certificate);
            }
            catch (XMLSignatureException e) {
                LOG.error((Object)"", (Throwable)e);
                throw new XKMSException(6, "failedXMLSign", e);
            }
        }
    }

    private void buildResultType(RegisterRequest request, RegisterResult result, String aliase, KeyStore ks) throws XKMSException {
        this.buildResultType((RequestAbstractType)request, (KRSSResult)result, aliase, ks);
        PrivateKey privateKey = this.getPrivateKey(aliase, ks);
        if (privateKey != null) {
            result.setPrivateKey(privateKey);
        }
    }

    private void buildResultType(ReissueRequest request, ReissueResult result, String aliase, KeyStore ks) throws XKMSException {
        this.buildResultType((RequestAbstractType)request, (KRSSResult)result, aliase, ks);
    }

    private void buildResultType(RecoverRequest request, RecoverResult result, String aliase, KeyStore ks) throws XKMSException {
        this.buildResultType((RequestAbstractType)request, (KRSSResult)result, aliase, ks);
        PrivateKey privateKey = this.getPrivateKey(aliase, ks);
        if (privateKey != null) {
            result.setPrivateKey(privateKey);
        }
    }

    private void buildResultType(RequestAbstractType request, KRSSResult result, String aliase, KeyStore ks) throws XKMSException {
        this.buildResultType(request, result);
        KeyBinding kb = XKMSUtil.createKeyBinding();
        result.addKeyBinding(kb);
        X509Certificate[] certs = this.getCertificates(aliase);
        List respondWithList = request.getRespondWith();
        this.addKeyInfo(respondWithList, aliase, certs, kb);
        this.addValidationInterval(certs[0], kb);
        this.addKeyUsage(certs[0], kb);
        this.addStatus(true, kb);
    }

    private void buildResultType(RequestAbstractType request, ResultType result) throws XKMSException {
        result.setServiceURI(request.getServiceURI());
        result.setResultMajor(ResultMajor.SUCCESS);
        result.setSignKey(this.sekey);
    }

    private PrivateKey getPrivateKey(String aliase, KeyStore ks) throws XKMSException {
        String passcode = this.properties.getProperty(XKMS_DEFAULT_PRIVATE_KEY_PASSWORD);
        java.security.PrivateKey private1 = this.getPrivateKey(aliase, passcode);
        if (private1 != null) {
            X509Certificate cert = this.getCertificate(aliase);
            PublicKey public1 = cert.getPublicKey();
            KeyPair keyPair = new KeyPair(public1, private1);
            PrivateKey privateKey = new PrivateKey();
            privateKey.setRSAKeyPair(keyPair);
            privateKey.setKey(this.enkey);
            return privateKey;
        }
        return null;
    }

    private String getSubjectDN(KeyBindingAbstractType abstractType) {
        List useKeyWiths = abstractType.getUseKeyWith();
        if (useKeyWiths == null || useKeyWiths.isEmpty()) {
            return null;
        }
        Iterator iterator = useKeyWiths.iterator();
        while (iterator.hasNext()) {
            UseKeyWith useKeyWith = (UseKeyWith)iterator.next();
            if (!"urn:ietf:rfc:2459".equals(useKeyWith.getApplication())) continue;
            return useKeyWith.getIdentifier();
        }
        return null;
    }

    private byte[] getSKIValue(KeyBindingAbstractType abstractType) {
        List useKeyWiths = abstractType.getUseKeyWith();
        if (useKeyWiths == null || useKeyWiths.isEmpty()) {
            return null;
        }
        Iterator iterator = useKeyWiths.iterator();
        while (iterator.hasNext()) {
            UseKeyWith useKeyWith = (UseKeyWith)iterator.next();
            if (!"urn:ietf:rfc:3080".equals(useKeyWith.getApplication())) continue;
            return Base64.decode((String)useKeyWith.getIdentifier());
        }
        return null;
    }

    private void loadKeyStore() {
        InputStream is = null;
        try {
            String wso2wsashome;
            String keyStorelocation = this.properties.getProperty(XKMS_KEY_STORE_LOCATION);
            String password = this.properties.getProperty(XKMS_KEY_STORE_PASSWORD);
            File keyStoreFile = new File(keyStorelocation);
            if (!keyStoreFile.exists() && (wso2wsashome = System.getProperty("wso2wsas.home")) != null) {
                keyStoreFile = new File(wso2wsashome + File.separator + "conf" + File.separator + keyStorelocation);
            }
            if (keyStoreFile.exists()) {
                try {
                    is = new FileInputStream(keyStorelocation);
                    this.properties.put(XKMS_KEY_STORE_LOCATION, keyStoreFile.getAbsolutePath());
                    this.canSupportPersistence = true;
                }
                catch (FileNotFoundException e) {
                    throw new Exception(e);
                }
            }
            if (is == null) {
                Resource resource;
                DiscoverResources disc = new DiscoverResources();
                disc.addClassLoader(JDKHooks.getJDKHooks().getThreadContextClassLoader());
                disc.addClassLoader(this.classLoader);
                ResourceIterator iterator = disc.findResources(keyStorelocation);
                if (iterator.hasNext()) {
                    resource = iterator.nextResource();
                    is = resource.getResourceAsStream();
                }
                if (is == null && (iterator = disc.findResources("META-INF/" + keyStorelocation)).hasNext()) {
                    resource = iterator.nextResource();
                    is = resource.getResourceAsStream();
                }
            }
            if (is == null) {
                throw new Exception("specified keystore doesn't exist");
            }
            this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keystore.load(is, password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Can't load keystore", e);
        }
    }

    private void saveKeystore() throws XKMSException {
        if (this.canSupportPersistence) {
            try {
                String location = this.properties.getProperty(XKMS_KEY_STORE_LOCATION);
                FileOutputStream outputStream = new FileOutputStream(location);
                String storePass = this.properties.getProperty(XKMS_KEY_STORE_PASSWORD);
                this.keystore.store(outputStream, storePass.toCharArray());
            }
            catch (FileNotFoundException ex) {
                throw new XKMSException(ex);
            }
            catch (KeyStoreException e) {
                throw new XKMSException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new XKMSException(e);
            }
            catch (CertificateException e) {
                throw new XKMSException(e);
            }
            catch (IOException e) {
                throw new XKMSException(e);
            }
        }
    }

    public java.security.PrivateKey getPrivateKey(String alias, String password) throws IllegalArgumentException {
        if (alias == null) {
            throw new IllegalArgumentException("alias is null");
        }
        try {
            boolean b = this.keystore.isKeyEntry(alias);
            if (!b) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Cannot find key for alias: " + alias));
                }
                return null;
            }
            Key keyTmp = this.keystore.getKey(alias, password.toCharArray());
            if (!(keyTmp instanceof java.security.PrivateKey)) {
                throw new IllegalArgumentException("Key is not a private key, alias: " + alias);
            }
            return (java.security.PrivateKey)keyTmp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addKeyInfo(List respondWiths, String aliase, X509Certificate[] certs, KeyBindingAbstractType abstractType) {
        KeyInfo keyInfo = new KeyInfo(this.doc);
        Iterator iterator = respondWiths.iterator();
        while (iterator.hasNext()) {
            RespondWith respondWith = (RespondWith)iterator.next();
            if (respondWith.equals(RespondWith.KEY_NAME)) {
                KeyName keyName = new KeyName(this.doc, aliase);
                keyInfo.add(keyName);
                continue;
            }
            if (respondWith.equals(RespondWith.KEY_VALUE)) {
                PublicKey publicKey = certs[0].getPublicKey();
                KeyValue keyValue = new KeyValue(this.doc, publicKey);
                keyInfo.add(keyValue);
                continue;
            }
            if (respondWith.equals(RespondWith.X_509_CERT)) {
                this.addX509Certificate(certs[0], keyInfo);
                continue;
            }
            if (!respondWith.equals(RespondWith.X_509_CHAIN)) continue;
            for (int i = 0; i < certs.length; ++i) {
                this.addX509Certificate(certs[i], keyInfo);
            }
        }
        abstractType.setKeyInfo(keyInfo);
    }

    private void addX509Certificate(X509Certificate cert, KeyInfo keyInfo) {
        X509Data data = new X509Data(this.doc);
        try {
            data.addCertificate(cert);
        }
        catch (XMLSecurityException se) {
            throw new RuntimeException("Adding the X509Certificate to X509Data object failed", se);
        }
        keyInfo.add(data);
    }

    private void addKeyUsage(X509Certificate cert, KeyBindingAbstractType kb) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null) {
            if (keyUsage[0]) {
                kb.addKeyUsage(KeyUsage.SIGNATURE);
            }
            if (keyUsage[3]) {
                kb.addKeyUsage(KeyUsage.ENCRYPTION);
            }
        }
    }

    private void addValidationInterval(X509Certificate cert, KeyBinding kb) {
        Date start = cert.getNotBefore();
        Date expiry = cert.getNotAfter();
        Calendar notBefore = Calendar.getInstance();
        notBefore.setTime(start);
        Calendar notAfter = Calendar.getInstance();
        notAfter.setTime(expiry);
        kb.setValidityInterval(notBefore, notAfter);
    }

    private void addStatus(boolean valid, KeyBinding kb) {
        Status status = new Status();
        status.setStatusValue(valid ? StatusValue.VALID : StatusValue.INVALID);
        if (valid) {
            status.addValidReason(ValidReason.ISSUER_TRUST);
            status.addValidReason(ValidReason.REVOCATION_STATUS);
            status.addValidReason(ValidReason.SIGNATURE);
            status.addValidReason(ValidReason.VALIDITY_INTERVAL);
        } else {
            status.addInvalidReason(InvalidReason.ISSUER_TRUST);
            status.addInvalidReason(InvalidReason.REVOCATION_STATUS);
            status.addInvalidReason(InvalidReason.SIGNATURE);
            status.addInvalidReason(InvalidReason.VALIDITY_INTERVAL);
        }
        kb.setStatus(status);
    }

    private Date[] getAdjustedValidityInterval(Calendar notBefore, Calendar notAfter) {
        Date start = notBefore == null ? null : notBefore.getTime();
        Date expiry = notAfter == null ? null : notAfter.getTime();
        return this.getAdjustedValidityInterval(start, expiry);
    }

    private Date[] getAdjustedValidityInterval(Date notBefore, Date notAfter) {
        Calendar ca = Calendar.getInstance();
        Date today = ca.getTime();
        Date start = notBefore != null ? (notBefore.before(today) ? today : notBefore) : today;
        if (notAfter == null) {
            ca.add(6, this.validityPeriod);
            notAfter = ca.getTime();
        }
        Date expiryDate = notAfter.after(this.caexpiry) ? this.caexpiry : notAfter;
        return new Date[]{start, expiryDate};
    }

    private void buildFault(RequestAbstractType requestType, ResultType resultType, XKMSException ex) {
        resultType.setServiceURI(requestType.getServiceURI());
        Throwable t = ex.getCause();
        if (t != null) {
            LOG.fatal((Object)"Exception is thrown when processing", t);
        }
        int errorCode = ex.getErrorCode();
        switch (errorCode) {
            case 6: {
                resultType.setResultMajor(ResultMajor.SENDER);
                resultType.setResultMinor(ResultMinor.NO_AUTHENTICATION);
                break;
            }
            case 1: {
                resultType.setResultMajor(ResultMajor.SUCCESS);
                resultType.setResultMinor(ResultMinor.NO_MATCH);
                break;
            }
            default: {
                resultType.setResultMajor(ResultMajor.RECEIVER);
                resultType.setResultMinor(ResultMinor.FAILURE);
            }
        }
    }

    private char[] getPrivateKeyPassword() {
        String password = this.properties.getProperty(XKMS_DEFAULT_PRIVATE_KEY_PASSWORD);
        return password.toCharArray();
    }

    private String createAlias(long serialNum) {
        String aliase = String.valueOf(serialNum);
        return aliase;
    }

    private long nextSerialNumber() {
        return System.currentTimeMillis();
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws XKMSException {
        return this.getAliasForX509Cert(issuer, serialNumber, true);
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber) throws XKMSException {
        Vector issuerRDN = this.splitAndTrim(issuer);
        X509Certificate x509cert = null;
        Vector certRDN = null;
        Certificate cert = null;
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate)) continue;
                x509cert = (X509Certificate)cert;
                if (useSerialNumber && (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0) || !(certRDN = this.splitAndTrim(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new XKMSException("keystore");
        }
        return null;
    }

    private Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    public String[] getAliasesForDN(String subjectDN) throws XKMSException {
        Vector subjectRDN = this.splitAndTrim(subjectDN);
        Vector aliases = this.getAlias(subjectRDN, this.keystore);
        if (aliases.size() == 0 && this.cacerts != null) {
            aliases = this.getAlias(subjectRDN, this.cacerts);
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.elementAt(i);
        }
        return result;
    }

    private Vector getAlias(Vector subjectRDN, KeyStore store) throws XKMSException {
        Vector<String> aliases = new Vector<String>();
        Certificate cert = null;
        try {
            Enumeration<String> e = store.aliases();
            while (e.hasMoreElements()) {
                Vector foundRDN;
                String alias = e.nextElement();
                Certificate[] certs = store.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = store.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                    certs = new Certificate[]{cert};
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(foundRDN = this.splitAndTrim(((X509Certificate)cert).getSubjectDN().getName()))) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new XKMSException(e);
        }
        return aliases;
    }

    public CertificateFactory getCertificateFactory() throws XKMSException {
        if (certFact == null) {
            try {
                String provider = this.properties.getProperty(PROP_ID_CERT_PROVIDER);
                certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new XKMSException("unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new XKMSException("noSecProvider");
            }
        }
        return certFact;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws XKMSException {
        try {
            List<X509Certificate> cert_list = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(cert_list);
            PKIXParameters param = new PKIXParameters(this.keystore);
            param.setRevocationEnabled(false);
            String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
            CertPathValidator validator = null;
            validator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            validator.validate(path, param);
        }
        catch (NoSuchProviderException e) {
            throw new XKMSException("certpath");
        }
        catch (NoSuchAlgorithmException e) {
            throw new XKMSException("certpath");
        }
        catch (CertificateException e) {
            throw new XKMSException("certpath");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XKMSException("certpath");
        }
        catch (CertPathValidatorException e) {
            throw new XKMSException("certpath");
        }
        catch (KeyStoreException e) {
            throw new XKMSException("certpath");
        }
        return true;
    }

    public X509Certificate getCertificate(String alias) throws XKMSException {
        Certificate[] certs = null;
        Certificate cert = null;
        try {
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.keystore.getCertificate(alias);
            }
            if (certs == null && cert == null && this.cacerts != null && (certs = this.cacerts.getCertificateChain(alias)) == null) {
                cert = this.cacerts.getCertificate(alias);
            }
            if (cert != null) {
                return (X509Certificate)cert;
            }
            if (certs == null) {
                return null;
            }
            return (X509Certificate)certs[0];
        }
        catch (KeyStoreException e) {
            throw new XKMSException("keystore");
        }
    }

    public X509Certificate[] getCertificates(String alias) throws XKMSException {
        Certificate[] certs = null;
        Certificate cert = null;
        try {
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.keystore.getCertificate(alias);
            }
            if (certs == null && cert == null && this.cacerts != null && (certs = this.cacerts.getCertificateChain(alias)) == null) {
                cert = this.cacerts.getCertificate(alias);
            }
            if (cert != null) {
                certs = new Certificate[]{cert};
            } else if (certs == null) {
                return null;
            }
        }
        catch (KeyStoreException e) {
            throw new XKMSException("keystore");
        }
        X509Certificate[] x509certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            x509certs[i] = (X509Certificate)certs[i];
        }
        return x509certs;
    }

    protected boolean verifyTrust(X509Certificate cert) throws XKMSException {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WSHandler: Transmitted certificate has subject " + subjectString));
            LOG.debug((Object)("WSHandler: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        if ((alias = this.getAliasForX509Cert(issuerString, issuerSerial)) != null) {
            certs = this.getCertificates(alias);
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Direct trust for certificate with " + subjectString));
                }
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        if ((aliases = this.getAliasesForDN(issuerString)) == null || aliases.length < 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString));
            }
            if ((certs = this.getCertificates(alias)) == null | certs.length < 1) {
                throw new XKMSException("noCertForAlias");
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length + 1];
            x509certs[0] = cert;
            for (int j = 0; j < certs.length; ++j) {
                x509certs[certs.length + j] = cert = certs[i];
            }
            certs = x509certs;
            if (!this.validateCertPath(certs)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WSHandler: Certificate path has been verified for certificate with subject " + subjectString));
            }
            return true;
        }
        LOG.debug((Object)("WSHandler: Certificate path could not be verified for certificate with subject " + subjectString));
        return false;
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws XKMSException {
        Certificate cert = null;
        boolean found = false;
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                byte[] data;
                String alias = e.nextElement();
                Certificate[] certs = this.keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = this.keystore.getCertificate(alias);
                    if (cert == null) {
                        return null;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (data = this.getSKIBytesFromCert((X509Certificate)cert)).length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new XKMSException(e);
        }
        return null;
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws XKMSException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new XKMSException("noSKIHandling");
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XKMSException("noSKIHandling");
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }
}

