/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.xkms2.IndeterminateReason;
import org.wso2.xkms2.InvalidReason;
import org.wso2.xkms2.Status;
import org.wso2.xkms2.StatusValue;
import org.wso2.xkms2.ValidReason;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ElementBuilder;

public class StatusBuilder
implements ElementBuilder {
    public static final StatusBuilder INSTANCE = new StatusBuilder();

    private StatusBuilder() {
    }

    public XKMSElement buildElement(OMElement element) throws XKMSException {
        String text;
        OMElement e;
        Status status = new Status();
        Iterator iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "ValidReason"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            text = e.getText();
            if (text == null) {
                throw new XKMSException("ValidReason elements test value is not available");
            }
            status.addValidReason(ValidReason.validate(text));
        }
        iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "IndeterminateReason"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            text = e.getText();
            if (text == null) {
                throw new XKMSException("IndeterminateReason elements text is not available");
            }
            status.addIndeterminateReason(IndeterminateReason.validate(text));
        }
        iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "InvalidReason"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            text = e.getText();
            if (text == null) {
                throw new XKMSException("InvalidReason elements text is not available");
            }
            status.addInvalidReason(InvalidReason.validate(text));
        }
        OMAttribute statusValueAtt = element.getAttribute(new QName("StatusValue"));
        if (statusValueAtt == null) {
            throw new XKMSException("StatusValue attribute is not available");
        }
        String statusValue = statusValueAtt.getAttributeValue();
        if (statusValue == null) {
            throw new XKMSException("Value of StatusValue attribute is not available");
        }
        status.setStatusValue(StatusValue.valueOf(statusValue));
        return status;
    }
}

