/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import org.apache.axiom.om.OMElement;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Element;
import org.wso2.xkms2.ReissueKeyBinding;
import org.wso2.xkms2.ReissueRequest;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.KRSSRequestBuilder;
import org.wso2.xkms2.builder.ReissueKeyBindingBuilder;

public class ReissueRequestBuilder
extends KRSSRequestBuilder {
    public static final ReissueRequestBuilder INSTANCE = new ReissueRequestBuilder();

    public XKMSElement buildElement(OMElement element) throws XKMSException {
        ReissueRequest reissueRequest = new ReissueRequest();
        super.buildElement(element, reissueRequest);
        OMElement reissueKeyBindingElement = element.getFirstChildWithName(XKMS2Constants.Q_ELEM_REISSUE_KEY_BINDING);
        if (reissueKeyBindingElement == null) {
            throw new XKMSException("ReissueKeyBinding element not found");
        }
        reissueRequest.setReissueKeyBinding((ReissueKeyBinding)ReissueKeyBindingBuilder.INSTANCE.buildElement(reissueKeyBindingElement));
        OMElement proofOfPossessionElem = element.getFirstChildWithName(XKMS2Constants.Q_ELEM_PROOF_OF_POSSESSION);
        if (proofOfPossessionElem != null) {
            OMElement xmlSigElem = proofOfPossessionElem.getFirstChildWithName(XKMS2Constants.Q_ELEM_XML_SIG);
            try {
                XMLSignature signature = new XMLSignature((Element)xmlSigElem, "");
                reissueRequest.setProofOfPocession(signature);
            }
            catch (XMLSignatureException e) {
                throw new XKMSException(e);
            }
            catch (XMLSecurityException e) {
                throw new XKMSException(e);
            }
        }
        return reissueRequest;
    }
}

