/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import org.apache.axiom.om.OMElement;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Element;
import org.wso2.xkms2.PrototypeKeyBinding;
import org.wso2.xkms2.RegisterRequest;
import org.wso2.xkms2.XKMS2Constants;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ElementBuilder;
import org.wso2.xkms2.builder.KRSSRequestBuilder;
import org.wso2.xkms2.builder.PrototypeKeyBindingBuilder;

public class RegisterRequestBuilder
extends KRSSRequestBuilder
implements ElementBuilder {
    public static final RegisterRequestBuilder INSTANCE = new RegisterRequestBuilder();
    private RegisterRequest registerRequest;

    private RegisterRequestBuilder() {
    }

    public XKMSElement buildElement(OMElement element) throws XKMSException {
        OMElement proofOfPossessionElem;
        this.registerRequest = new RegisterRequest();
        super.buildElement(element, this.registerRequest);
        OMElement prototypeKeyBindingElem = element.getFirstChildWithName(XKMS2Constants.Q_ELEM_PROTOTYPE_KEY_BINDING);
        if (prototypeKeyBindingElem != null) {
            this.processPrototypeKeyBinding(prototypeKeyBindingElem);
        }
        if ((proofOfPossessionElem = element.getFirstChildWithName(XKMS2Constants.Q_ELEM_PROOF_OF_POSSESSION)) != null) {
            this.processProofOfPossession(proofOfPossessionElem);
        }
        return this.registerRequest;
    }

    private void processPrototypeKeyBinding(OMElement prototypeKeyBindingElem) throws XKMSException {
        PrototypeKeyBinding prototypeKeyBinding = (PrototypeKeyBinding)PrototypeKeyBindingBuilder.INSTANCE.buildElement(prototypeKeyBindingElem);
        this.registerRequest.setPrototypeKeyBinding(prototypeKeyBinding);
    }

    private void processProofOfPossession(OMElement proofOfPossessionElem) throws XKMSException {
        Element sigElement = (Element)proofOfPossessionElem.getFirstChildWithName(XKMS2Constants.Q_ELEM_XML_SIG);
        try {
            XMLSignature signature = new XMLSignature(sigElement, "");
            this.registerRequest.setProofOfPossesion(signature);
        }
        catch (XMLSignatureException e) {
            throw new XKMSException(e);
        }
        catch (XMLSecurityException e) {
            throw new XKMSException(e);
        }
    }
}

