/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;
import org.wso2.xkms2.MessageAbstractType;
import org.wso2.xkms2.OpaqueClientData;
import org.wso2.xkms2.OpaqueData;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ElementBuilder;

public abstract class MessageAbstractTypeBuilder
implements ElementBuilder {
    public void buildElement(OMElement element, MessageAbstractType messageAbstractType) throws XKMSException {
        OMAttribute idAttr;
        OMElement opaqueClientDataEle;
        OMElement sigEle = element.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"));
        if (sigEle != null) {
            XMLSignature xmlSig;
            Element xmlSigEle = (Element)sigEle;
            try {
                xmlSig = new XMLSignature(xmlSigEle, null);
            }
            catch (XMLSecurityException e) {
                throw new XKMSException(e);
            }
            messageAbstractType.setSignature(xmlSig);
        }
        if ((opaqueClientDataEle = element.getFirstChildWithName(new QName("http://www.w3.org/2002/03/xkms#", "OpaqueClientData"))) != null) {
            OpaqueClientData opaqueClientData = new OpaqueClientData();
            Iterator iterator = opaqueClientDataEle.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "OpaqueData"));
            while (iterator.hasNext()) {
                OMElement e = (OMElement)iterator.next();
                OMText binaryNode = (OMText)e.getFirstOMChild();
                OpaqueData opaqueData = new OpaqueData();
                String text = binaryNode.getText();
                opaqueData.setBase64Binary(Base64.decode((String)text));
                opaqueClientData.addOpaqueData(opaqueData);
                messageAbstractType.setOpaqueClientData(opaqueClientData);
            }
        }
        if ((idAttr = element.getAttribute(new QName("Id"))) == null) {
            throw new XKMSException("Mandatory Id attribute is not found.");
        }
        String attributeValue = idAttr.getAttributeValue();
        if (attributeValue == null) {
            throw new XKMSException("Value of Id attribute cannot be found");
        }
        messageAbstractType.setId(attributeValue);
        OMAttribute serviceAttr = element.getAttribute(new QName("Service"));
        if (serviceAttr == null) {
            throw new XKMSException("Mandatory Service attribute cannot be found");
        }
        attributeValue = serviceAttr.getAttributeValue();
        if (attributeValue == null) {
            throw new XKMSException("Value for Service attribute is not found");
        }
        messageAbstractType.setServiceURI(attributeValue);
        OMAttribute nonceAttr = element.getAttribute(new QName("Nonce"));
        if (nonceAttr != null && (attributeValue = nonceAttr.getAttributeValue()) != null) {
            messageAbstractType.setNonce(attributeValue.getBytes());
        }
    }

    static {
        Init.init();
    }
}

