/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.w3c.dom.Element;
import org.wso2.xkms2.KeyBindingAbstractType;
import org.wso2.xkms2.KeyUsage;
import org.wso2.xkms2.UseKeyWith;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ElementBuilder;

public abstract class KeyBindingAbstractTypeBuilder
implements ElementBuilder {
    public void buildElement(OMElement element, KeyBindingAbstractType keyBindingAbstractType) throws XKMSException {
        OMElement e;
        OMElement keyInfoEle = element.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        if (keyInfoEle != null) {
            Element kiEle = (Element)keyInfoEle;
            try {
                KeyInfo ki = new KeyInfo(kiEle, null);
                keyBindingAbstractType.setKeyInfo(ki);
            }
            catch (XMLSecurityException e2) {
                throw new XKMSException(e2);
            }
        }
        Iterator iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "KeyUsage"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            keyBindingAbstractType.addKeyUsage(KeyUsage.valueOf(e.getText()));
        }
        iterator = element.getChildrenWithName(new QName("http://www.w3.org/2002/03/xkms#", "UseKeyWith"));
        while (iterator.hasNext()) {
            e = (OMElement)iterator.next();
            UseKeyWith useKeyWith = new UseKeyWith();
            OMAttribute applicationAttr = e.getAttribute(new QName("Application"));
            if (applicationAttr == null) {
                throw new XKMSException("Required attribute Application is not available.");
            }
            String attributeValue = applicationAttr.getAttributeValue();
            if (attributeValue == null) {
                throw new XKMSException("Value cannot be found for Application attribute");
            }
            useKeyWith.setApplication(attributeValue);
            OMAttribute identifierAttr = e.getAttribute(new QName("Identifier"));
            if (identifierAttr == null) {
                throw new XKMSException("Required attribute Identifier is not available");
            }
            attributeValue = identifierAttr.getAttributeValue();
            if (attributeValue == null) {
                throw new XKMSException("Value cannot be found for Identifier attribute");
            }
            useKeyWith.setIdentifier(attributeValue);
            keyBindingAbstractType.addUseKeyWith(useKeyWith);
        }
        OMAttribute idAttr = element.getAttribute(new QName("Id"));
        if (idAttr != null) {
            keyBindingAbstractType.setId(idAttr.getAttributeValue());
        }
    }
}

