/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xkms2;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.xkms2.MessageExtension;
import org.wso2.xkms2.OpaqueClientData;
import org.wso2.xkms2.XKMSElement;
import org.wso2.xkms2.XKMSException;

public class MessageAbstractType
implements XKMSElement {
    private XMLSignature signature;
    private List messageExtensionList;
    private OpaqueClientData opaqueClientData;
    private String id;
    private String serviceURI;
    private byte[] nonce;
    private Key signKey;
    private X509Certificate signCert;

    public XMLSignature getSignature() {
        return this.signature;
    }

    public void setSignature(XMLSignature signature) {
        this.signature = signature;
    }

    public void setSignKey(Key signKey) {
        this.signKey = signKey;
    }

    public Key getSignKey() {
        return this.signKey;
    }

    public void setSignCert(X509Certificate signCert) {
        this.signCert = signCert;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }

    public List getMessageExtensionList() {
        return this.messageExtensionList;
    }

    public void setMessageExtensionList(List messageExtensionList) {
        this.messageExtensionList = messageExtensionList;
    }

    public void addMessageExtension(MessageExtension messageExtension) {
        this.messageExtensionList.add(messageExtension);
    }

    public OpaqueClientData getOpaqueClientData() {
        return this.opaqueClientData;
    }

    public void setOpaqueClientData(OpaqueClientData opaqueClientData) {
        this.opaqueClientData = opaqueClientData;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public void setServiceURI(String serviceURI) {
        this.serviceURI = serviceURI;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    protected void serialize(OMFactory factory, OMElement container) throws XKMSException {
        OMElement ele;
        if (this.signature != null) {
            Element sigElement = this.signature.getElement();
            Element containerDOMElement = (Element)container;
            Document ownerDocument = containerDOMElement.getOwnerDocument();
            Node node = ownerDocument.importNode(sigElement, true);
            containerDOMElement.appendChild(node);
        }
        if (this.opaqueClientData != null && (ele = this.opaqueClientData.serialize(factory)) != null) {
            container.addChild((OMNode)ele);
        }
        if (this.id == null) {
            throw new XKMSException("Required element Id is not set");
        }
        OMNamespace emptyNs = factory.createOMNamespace("", "");
        container.addAttribute("Id", this.id, emptyNs);
        if (this.serviceURI == null) {
            throw new XKMSException("Required element Service is not set");
        }
        container.addAttribute("Service", this.serviceURI, emptyNs);
        if (this.nonce != null) {
            container.addAttribute("Nonce", new String(this.nonce), emptyNs);
        }
    }
}

