/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.xfer;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.wso2.xfer.WSTransferException;

public class WSTransferUtil {
    public static void triggerMessageInfoHeaderRequiredFault(MessageContext messageContext, String missingHeaderName) throws AxisFault {
        AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)messageContext, (String)missingHeaderName);
    }

    public static void triggerInvalidMessageInfoHeaderFault(MessageContext messageContext, String invalidHeader) throws AxisFault {
        AddressingFaultsHelper.triggerInvalidCardinalityFault((MessageContext)messageContext, (String)invalidHeader);
    }

    public static void triggerInvalidRepresentationFault(MessageContext messageContext, String detail) throws AxisFault {
        QName faultCode = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender", "soapenv");
        QName faultSubcode = new QName("http://schemas.xmlsoap.org/ws/2004/08/transfer", "InvaildRepresentation", "wxf");
        if (!messageContext.isSOAP11()) {
            SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
            SOAPFaultDetail soapFaultDetail = factory.createSOAPFaultDetail();
            OMElement faultDetailElement = factory.createOMElement("FaultDetail", "http://schemas.xmlsoap.org/ws/2005/06/management", "wsma");
            faultDetailElement.setText(detail);
            soapFaultDetail.addChild((OMNode)faultDetailElement);
            messageContext.setProperty("Detail", (Object)soapFaultDetail);
        }
        WSTransferUtil.triggerAxisFault(messageContext, "InvalidRepresentationDetail", detail, faultCode, faultSubcode, "The XML content was invaild");
    }

    public static void triggerAxisFault(MessageContext msgCtx, String faultInfoKey, String faultInfoValue, QName faultCode, QName faultSubcode, String faultReason) throws AxisFault {
        if (faultInfoKey != null) {
            HashMap<String, String> faultInfoForHeaders = (HashMap<String, String>)msgCtx.getProperty("FaultHeaders");
            if (faultInfoForHeaders == null) {
                faultInfoForHeaders = new HashMap<String, String>();
                msgCtx.setProperty("FaultHeaders", faultInfoForHeaders);
            }
            faultInfoForHeaders.put(faultInfoKey, faultInfoValue);
        }
        if (!msgCtx.isSOAP11()) {
            WSTransferUtil.setFaultCodeForSOAP12(msgCtx, faultCode, faultSubcode);
        }
        OperationContext opCtx = msgCtx.getOperationContext();
        opCtx.setProperty("sendStacktraceDetailsWithFaults", (Object)Boolean.FALSE);
        throw new AxisFault(faultReason, faultSubcode);
    }

    private static void setFaultCodeForSOAP12(MessageContext msgContext, QName faultCode, QName faultSubcode) throws AxisFault {
        SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
        SOAPFaultCode soapFaultCode = factory.createSOAPFaultCode();
        SOAPFaultValue soapFaultValue = factory.createSOAPFaultValue(soapFaultCode);
        soapFaultValue.setText(faultCode.getPrefix() + ":" + faultCode.getLocalPart());
        SOAPFaultSubCode soapFaultSubCode = factory.createSOAPFaultSubCode(soapFaultCode);
        SOAPFaultValue soapFaultSubCodeValue = factory.createSOAPFaultValue(soapFaultSubCode);
        soapFaultSubCodeValue.setText(faultSubcode.getPrefix() + ":" + faultSubcode.getLocalPart());
        msgContext.setProperty("Code", (Object)soapFaultCode);
    }

    public static void triggerAxisFault(MessageContext messageContext, WSTransferException wste) throws AxisFault {
        SOAPEnvelope envelope = messageContext.getEnvelope();
        SOAPFactory fac = (SOAPFactory)envelope.getOMFactory();
        String soapNSURI = fac.getSoapVersionURI();
        SOAPFaultCode faultCode = fac.createSOAPFaultCode();
        SOAPFaultValue faultCodeValue = fac.createSOAPFaultValue(faultCode);
        faultCodeValue.setText(wste.getCode());
        SOAPFaultSubCode faultSubCode = fac.createSOAPFaultSubCode(faultCode);
        SOAPFaultValue faultSubCodeValue = fac.createSOAPFaultValue(faultSubCode);
        faultSubCodeValue.setText(wste.getSubCode());
        SOAPFaultReason faultReason = fac.createSOAPFaultReason();
        SOAPFaultText faultText = fac.createSOAPFaultText(faultReason);
        faultText.setText(wste.getReason());
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapNSURI)) {
            messageContext.setProperty("faultcode", (Object)faultCode);
            messageContext.setProperty("faultstring", (Object)faultReason);
        } else {
            messageContext.setProperty("Code", (Object)faultCode);
            messageContext.setProperty("Reason", (Object)faultReason);
            String detail = wste.getDetail();
            if (detail != null) {
                SOAPFaultDetail faultDetail = fac.createSOAPFaultDetail();
                faultDetail.setText(detail);
                messageContext.setProperty("Detail", (Object)faultDetail);
            }
        }
        throw AxisFault.makeFault((Throwable)wste);
    }
}

