/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2code.ui;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.wsdl2code.stub.WSDL2CodeServiceStub;
import org.wso2.carbon.wsdl2code.stub.types.carbon.CodegenDownloadData;

public class WSDL2CodeClient {
    private static final Log log = LogFactory.getLog(WSDL2CodeClient.class);
    public WSDL2CodeServiceStub stub;

    public WSDL2CodeClient(ConfigurationContext configContext, String backendServerURL, String cookie) throws AxisFault {
        String backendServiceURL = backendServerURL + "WSDL2CodeService";
        this.stub = new WSDL2CodeServiceStub(configContext, backendServiceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void codeGen(String[] options, HttpServletResponse response) throws AxisFault {
        try {
            ServletOutputStream out = response.getOutputStream();
            CodegenDownloadData downloadData = this.stub.codegen(options);
            if (downloadData != null) {
                int nextChar;
                DataHandler handler = downloadData.getCodegenFileData();
                response.setHeader("Content-Disposition", "fileName=" + downloadData.getFileName());
                response.setContentType(handler.getContentType());
                InputStream in = handler.getDataSource().getInputStream();
                while ((nextChar = in.read()) != -1) {
                    out.write((int)((char)nextChar));
                }
                out.flush();
                in.close();
            } else {
                out.write("The requested service archive was not found on the server".getBytes());
            }
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }
}

