/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2code.ui;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.ui.CarbonUIUtil;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);

    public static String getRelativeUrl() {
        BundleContext context = CarbonUIUtil.getBundleContext();
        ServiceReference reference = context.getServiceReference(RegistryService.class.getName());
        RegistryService registryService = (RegistryService)context.getService(reference);
        String url = null;
        try {
            UserRegistry systemRegistry = registryService.getConfigSystemRegistry();
            Resource resource = systemRegistry.get("/repository/connection/props");
            String servicePath = resource.getProperty("service-path");
            String contextRoot = resource.getProperty("context-root");
            contextRoot = contextRoot.equals("/") ? "" : contextRoot;
            url = contextRoot + servicePath + "/WSDL2CodeService";
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return url;
    }

    public static OMElement getCodegenOptions(String configFile) {
        InputStream stream = Util.class.getResourceAsStream(configFile);
        StAXOMBuilder builder = null;
        OMElement omElement = null;
        try {
            builder = new StAXOMBuilder(stream);
            omElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return omElement;
    }
}

