/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.wsdl2code.ui.fileupload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class WSDL2CodeFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".wsdl", ".xml", ".zip"};

    public void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        PrintWriter out = response.getWriter();
        try {
            List fileItemDataList = this.getAllFileItems();
            String filePaths = "";
            for (FileItemData fileItemData : fileItemDataList) {
                String serviceUploadDir;
                FileItem fileItem = fileItemData.getFileItem();
                String fileName = this.getFileName(fileItem.getName());
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                if (fileName.endsWith(".wsdl") || fileName.endsWith(".xml")) {
                    String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                    serviceUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
                    File dir = new File(serviceUploadDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    File uploadedFile = new File(dir, uuid + ".xml");
                    FileOutputStream fileOutStream = new FileOutputStream(uploadedFile);
                    fileItemData.getDataHandler().writeTo((OutputStream)fileOutStream);
                    fileOutStream.flush();
                    fileOutStream.close();
                    response.setContentType("text/plain; charset=utf-8");
                    String outPath = File.separator + "extra" + File.separator + uploadedFile.getAbsolutePath().split(File.separator + "tmp" + File.separator + "work" + File.separator + "extra" + File.separator)[1];
                    filePaths = filePaths + outPath + ",";
                    filePaths = filePaths.substring(0, filePaths.length() - 1);
                    out.write(filePaths);
                    out.flush();
                } else if (fileName.endsWith(".zip")) {
                    ZipInputStream zipInputStream = null;
                    try {
                        ZipEntry ze;
                        zipInputStream = new ZipInputStream(fileItemData.getFileItem().getInputStream());
                        serviceUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "extra" + File.separator;
                        String uuidDir = String.valueOf((double)System.currentTimeMillis() + Math.random());
                        String zipPath = serviceUploadDir + uuidDir;
                        new File(zipPath).mkdir();
                        while ((ze = zipInputStream.getNextEntry()) != null) {
                            File destinationFilePath = new File(zipPath, ze.getName());
                            destinationFilePath.getParentFile().mkdirs();
                            if (ze.isDirectory()) continue;
                            if (ze.getName().endsWith(".wsdl")) {
                                String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                                destinationFilePath = new File(destinationFilePath.getParent() + File.separator + uuid + ".xml");
                                response.setContentType("text/plain; charset=utf-8");
                                String outPath = File.separator + "extra" + File.separator + destinationFilePath.getAbsolutePath().split(File.separator + "tmp" + File.separator + "work" + File.separator + "extra" + File.separator)[1];
                                filePaths = filePaths + outPath + ",";
                            }
                            this.copyInputStream(zipInputStream, new BufferedOutputStream(new FileOutputStream(destinationFilePath)));
                            zipInputStream.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        throw new Exception(e);
                    }
                    finally {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                    }
                    if (filePaths.length() == 0) {
                        throw new Exception("No WSDL found in the provided archive " + fileName);
                    }
                    filePaths = filePaths.substring(0, filePaths.length() - 1);
                    out.write(filePaths);
                    out.flush();
                }
                log.info((Object)("File Successfully Uploaded " + fileName));
            }
        }
        catch (Exception e) {
            log.error((Object)"File upload FAILED", (Throwable)e);
            out.write("<script type=\"text/javascript\">top.wso2.wsf.Util.alertWarning('File upload FAILED. File may be non-existent or invalid.');</script>");
        }
        finally {
            out.close();
        }
        return true;
    }
}

