/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2034
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2034(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Definition def = (Definition)entryContext.getEntry().getEntryDetail();
        String xmlNs = (String)def.getNamespaces().get("xml");
        if (xmlNs != null && xmlNs.equals("http://www.w3.org/XML/1998/namespace")) {
            this.result = "warning";
        } else {
            Types types = def.getTypes();
            if (types != null) {
                List extElems = types.getExtensibilityElements();
                for (int i = 0; i < extElems.size(); ++i) {
                    Schema schema = (Schema)extElems.get(i);
                    String attrValue = schema.getElement().getAttributeNS("http://www.w3.org/2000/xmlns/", "xml");
                    if (!"http://www.w3.org/XML/1998/namespace".equals(attrValue)) continue;
                    this.result = "warning";
                    this.failureDetail = this.validator.createFailureDetail("The namespace declaration nested in wsdl:schema element.", entryContext);
                    break;
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

