/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import org.apache.xerces.util.URI;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2020
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2020(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        boolean rpcLitFound = false;
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPBinding soapBinding = WSDLValidatorImpl.getSoapBinding(binding);
        String style = "document";
        if (soapBinding != null) {
            String string = style = soapBinding.getStyle() == null ? "document" : soapBinding.getStyle();
        }
        if (soapBinding != null && style.equals("rpc")) {
            SOAPBody[] soapBodies = this.validator.getSoapBodies(binding);
            boolean assertionFailure = false;
            String namespaceURI = null;
            for (int i = 0; i < soapBodies.length && !assertionFailure; ++i) {
                SOAPBody soapBody = soapBodies[i];
                if (soapBody.getUse() != null && !soapBody.getUse().equals("literal")) continue;
                rpcLitFound = true;
                namespaceURI = soapBody.getNamespaceURI();
                if (namespaceURI == null) {
                    assertionFailure = true;
                    this.failureDetail = this.validator.createFailureDetail("--- SOAP BODY:\n" + soapBody.toString() + "\n--- BINDING QNAME:\n" + binding.getQName(), entryContext);
                    continue;
                }
                try {
                    URI uri = new URI(namespaceURI);
                    if (uri.getScheme() != null) continue;
                    assertionFailure = true;
                    this.failureDetail = this.validator.createFailureDetail("--- SOAP BODY:\n" + soapBody.toString() + "\n--- BINDING QNAME:\n" + binding.getQName(), entryContext);
                    continue;
                }
                catch (URI.MalformedURIException mue) {
                    assertionFailure = true;
                    this.failureDetail = this.validator.createFailureDetail("--- SOAP BODY:\n" + soapBody.toString() + "\n--- BINDING QNAME:\n" + binding.getQName(), entryContext);
                }
            }
            if (!rpcLitFound) {
                this.result = "notApplicable";
                this.failureDetail = null;
            } else if (!assertionFailure) {
                this.result = "passed";
                this.failureDetail = null;
            }
        } else {
            this.result = "notApplicable";
            this.failureDetail = null;
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

