/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP1213
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1213(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document doc = entryContext.getMessageEntryDocument();
            Element messageElement = null;
            if (doc == null || this.validator.isFault(doc) || (messageElement = this.validator.getSoapBodyChild(doc)) == null) {
                throw new AssertionNotApplicableException();
            }
            QName messagePartElementQName = new QName(messageElement.getNamespaceURI(), messageElement.getLocalName());
            BindingOperation[] docBindingOperations = this.validator.getMatchingBindingOps("document", this.validator.analyzerContext.getCandidateInfo().getBindings());
            BindingOperation[] potentialDocLitOps = this.validator.getDocLitOperations(entryContext.getEntry().getEntryType(), messagePartElementQName, docBindingOperations);
            if (potentialDocLitOps.length != 1) {
                throw new AssertionNotApplicableException();
            }
            List extElems = null;
            if (entryContext.getMessageEntry().getType().equals("request") && potentialDocLitOps[0].getBindingInput() != null) {
                extElems = potentialDocLitOps[0].getBindingInput().getExtensibilityElements();
            } else if (entryContext.getMessageEntry().getType().equals("response") && potentialDocLitOps[0].getBindingOutput() != null) {
                extElems = potentialDocLitOps[0].getBindingOutput().getExtensibilityElements();
            }
            List parts = null;
            SOAPBody soapBody = this.validator.getSOAPBody(extElems);
            if (soapBody != null) {
                parts = soapBody.getParts();
            }
            if (parts != null && parts.isEmpty() && !XMLUtils.getChildElements(messageElement).isEmpty()) {
                throw new AssertionFailException("wsdl:operation name is " + potentialDocLitOps[0].getName());
            }
        }
        catch (AssertionNotApplicableException anae) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

