/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.wst.wsi.internal.core.ToolEnvironment;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.util.XMLInfo;

public class ToolInfo {
    public static final String PROP_TOOL_VERSION = "wsi.tool.version";
    public static final String PROP_TOOL_RELEASE_DATE = "wsi.tool.release.date";
    public static final String PROP_TOOL_IMPLEMENTER = "wsi.tool.implementer";
    public static final String PROP_TOOL_LOCATION = "wsi.tool.location";
    private static final String DEF_TOOL_VERSION = "1.0.1";
    private static final String DEF_TOOL_RELEASE_DATE = "2004-01-22";
    private static final String DEF_TOOL_IMPLEMENTER = "Eclipse.org Organization";
    private static final String DEF_TOOL_LOCATION = "http://www.eclipse.org/wsvt";
    protected String name;
    protected String version;
    protected String releaseDate;
    protected String implementer;
    protected String location;
    protected ToolEnvironment toolEnvironment = null;
    public static final String PROP_FILENAME = "org.wsi.test.toolinfo";
    private static final String COMMENTS = "";

    public ToolInfo() {
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String name) {
        this.name = name;
        this.getProperties();
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String name, String version, String releaseDate, String implementer, String location) {
        this.name = name;
        this.version = version;
        this.releaseDate = releaseDate;
        this.implementer = implementer;
        this.location = location;
        this.toolEnvironment = new ToolEnvironment();
    }

    public ToolInfo(String name, String version, String releaseDate, String implementer, String location, XMLInfo xmlInfo) {
        this.name = name;
        this.version = version;
        this.releaseDate = releaseDate;
        this.implementer = implementer;
        this.location = location;
        this.toolEnvironment = new ToolEnvironment(xmlInfo);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getImplementer() {
        return this.implementer;
    }

    public String getLocation() {
        return this.location;
    }

    public ToolEnvironment getToolEnvironment() {
        return this.toolEnvironment;
    }

    public void setImplementer(String implementer) {
        this.implementer = implementer;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public void setToolEnvironment(ToolEnvironment toolEnvironment) {
        this.toolEnvironment = toolEnvironment;
    }

    public void setAdditionalToolEnvironment(XMLInfo xmlInfo) {
        this.toolEnvironment.setAdditionalToolEnvironment(xmlInfo);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getStartXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals(COMMENTS)) {
            nsName = nsName + ":";
        }
        pw.print("  <" + nsName + this.getName().toLowerCase() + " ");
        pw.print("version=\"" + this.getVersion() + "\" ");
        pw.println("releaseDate=\"" + this.getReleaseDate() + "\">");
        pw.print("    <" + nsName + "implementer" + " ");
        pw.print("name=\"" + this.getImplementer() + "\" ");
        pw.println("location=\"" + this.getLocation() + "\"/>");
        pw.print(this.toolEnvironment.toXMLString(namespaceName));
        return sw.toString();
    }

    public String getEndXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals(COMMENTS)) {
            nsName = nsName + ":";
        }
        pw.println("  </" + nsName + this.getName().toLowerCase() + ">");
        return sw.toString();
    }

    protected void getProperties() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PROP_FILENAME);
            this.version = this.getProperty(resourceBundle, PROP_TOOL_VERSION, DEF_TOOL_VERSION);
            this.releaseDate = this.getProperty(resourceBundle, PROP_TOOL_RELEASE_DATE, DEF_TOOL_RELEASE_DATE);
            this.implementer = this.getProperty(resourceBundle, PROP_TOOL_IMPLEMENTER, DEF_TOOL_IMPLEMENTER);
            this.location = this.getProperty(resourceBundle, PROP_TOOL_LOCATION, DEF_TOOL_LOCATION);
        }
        catch (MissingResourceException mre) {
            this.version = DEF_TOOL_VERSION;
            this.releaseDate = DEF_TOOL_RELEASE_DATE;
            this.implementer = DEF_TOOL_IMPLEMENTER;
            this.location = DEF_TOOL_LOCATION;
        }
    }

    protected String getProperty(ResourceBundle resourceBundle, String key, String defaultValue) {
        String value = resourceBundle.getString(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void main(String[] args) {
        int statusCode = 0;
        String filename = PROP_FILENAME;
        String version = DEF_TOOL_VERSION;
        String implementer = DEF_TOOL_IMPLEMENTER;
        String location = DEF_TOOL_LOCATION;
        if (args.length >= 1) {
            filename = args[0];
        }
        if (args.length >= 2) {
            version = args[1];
        }
        if (args.length >= 3) {
            implementer = args[2];
        }
        if (args.length >= 4) {
            location = args[3];
        }
        try {
            FileWriter fileWriter = new FileWriter(filename);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(COMMENTS);
            printWriter.println("wsi.tool.version=" + version);
            printWriter.println("wsi.tool.release.date=" + Utils.getDate());
            printWriter.println("wsi.tool.implementer=" + implementer);
            printWriter.println("wsi.tool.location=" + location);
            fileWriter.close();
            System.out.println("File [" + filename + "] created.");
        }
        catch (IOException ioe) {
            statusCode = 1;
            System.out.println("EXCEPTION: " + ioe.toString());
            ioe.printStackTrace();
        }
        System.exit(statusCode);
    }
}

