/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal.facets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.facets.FacetMappingUtil;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetMapping;

public class RuntimeBridge
implements IRuntimeBridge {
    protected static Map mappings = new HashMap();

    static {
        RuntimeBridge.initialize();
    }

    private static void addMapping(String id, String id2, String version) {
        ArrayList<IRuntimeComponentVersion> list = null;
        try {
            list = (ArrayList<IRuntimeComponentVersion>)mappings.get(id);
        }
        catch (Exception exception) {}
        if (list == null) {
            list = new ArrayList<IRuntimeComponentVersion>(2);
        }
        try {
            list.add(RuntimeManager.getRuntimeComponentType(id2).getVersion(version));
            mappings.put(id, list);
        }
        catch (Exception exception) {}
    }

    private static void initialize() {
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        int size = runtimeTypes.length;
        int i = 0;
        while (i < size) {
            RuntimeType rt = (RuntimeType)runtimeTypes[i];
            String component = rt.getFacetRuntimeComponent();
            String version = rt.getFacetRuntimeVersion();
            if (component != null && !"".equals(component) && version != null && !"".equals(version)) {
                RuntimeBridge.addMapping(rt.getId(), component, version);
            }
            ++i;
        }
        RuntimeFacetMapping[] rfms = FacetMappingUtil.getRuntimeFacetMapping();
        size = rfms.length;
        int i2 = 0;
        while (i2 < size) {
            RuntimeBridge.addMapping(rfms[i2].getRuntimeTypeId(), rfms[i2].getRuntimeComponent(), rfms[i2].getVersion());
            ++i2;
        }
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.jboss323", "org.eclipse.jst.server.generic.runtime.jboss", "3.2.3");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.jonas4", "org.eclipse.jst.server.generic.runtime.jonas", "4.0");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.oracle1013", "org.eclipse.jst.server.generic.runtime.oracle", "10.1.3");
        RuntimeBridge.addMapping("org.eclipse.jst.server.generic.runtime.websphere.6", "org.eclipse.jst.server.generic.runtime.websphere", "6.0");
    }

    public Set getExportedRuntimeNames() throws CoreException {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        HashSet<String> result = new HashSet<String>(runtimes.length);
        int i = 0;
        while (i < runtimes.length) {
            IRuntime runtime = runtimes[i];
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null && mappings.containsKey(runtimeType.getId())) {
                result.add(runtime.getId());
            }
            ++i;
        }
        return result;
    }

    public IRuntimeBridge.IStub bridge(String name) throws CoreException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int size = runtimes.length;
        int i = 0;
        while (i < size) {
            if (runtimes[i].getId().equals(name)) {
                return new Stub(runtimes[i]);
            }
            ++i;
        }
        return null;
    }

    private static class Stub
    implements IRuntimeBridge.IStub {
        private IRuntime runtime;

        public Stub(IRuntime runtime) {
            this.runtime = runtime;
        }

        public List getRuntimeComponents() {
            String typeId;
            ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>(2);
            if (this.runtime == null) {
                return components;
            }
            HashMap<String, String> properties = new HashMap<String, String>(5);
            if (this.runtime.getLocation() != null) {
                properties.put("location", this.runtime.getLocation().toPortableString());
            } else {
                properties.put("location", "");
            }
            properties.put("name", this.runtime.getName());
            properties.put("id", this.runtime.getId());
            if (this.runtime.getRuntimeType() != null) {
                properties.put("type", this.runtime.getRuntimeType().getName());
                properties.put("type-id", this.runtime.getRuntimeType().getId());
            }
            if (mappings.containsKey(typeId = this.runtime.getRuntimeType().getId())) {
                ArrayList list = (ArrayList)mappings.get(typeId);
                int size = list.size();
                int i = 0;
                while (i < size) {
                    IRuntimeComponentVersion mapped = (IRuntimeComponentVersion)list.get(i);
                    components.add(RuntimeManager.createRuntimeComponent(mapped, properties));
                    ++i;
                }
            }
            FacetMappingUtil.addFacetRuntimeComponents(this.runtime, components);
            return components;
        }

        public Map getProperties() {
            HashMap<String, String> props = new HashMap<String, String>();
            if (this.runtime != null) {
                props.put("id", this.runtime.getId());
                props.put("localized-name", this.runtime.getName());
            }
            return props;
        }
    }
}

