/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef;
import org.eclipse.wst.common.project.facet.core.internal.util.PluginUtil;

public final class FacetedProjectValidationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.wst.common.project.facet.core.builder";
    private static final String EXTENSION_POINT_ID = "validators";
    private static final String EL_VALIDATOR = "validator";
    private static final String EL_FACET = "facet";
    private static final String ATTR_CLASS = "class";
    private static final List<ValidatorDefinition> validators = new ArrayList<ValidatorDefinition>();

    static {
        FacetedProjectValidationBuilder.readExtensions();
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(Resources.taskDescription, 3);
        }
        try {
            IProject proj = this.getProject();
            IFacetedProject fproj = ProjectFacetsManager.create(proj);
            proj.deleteMarkers("org.eclipse.wst.common.project.facet.core.validation.marker", true, 2);
            FacetedProjectValidationBuilder.worked(monitor, 1);
            IStatus st = fproj.validate((IProgressMonitor)FacetedProjectValidationBuilder.submon(monitor, 1));
            if (!st.isOK()) {
                IStatus[] problems = st.getChildren();
                int i = 0;
                while (i < problems.length) {
                    IStatus problem = problems[i];
                    int severity = problem.getSeverity();
                    String message = problem.getMessage();
                    if (severity == 4) {
                        fproj.createErrorMarker(message);
                    } else if (severity == 2) {
                        fproj.createWarningMarker(message);
                    }
                    ++i;
                }
            }
            for (ValidatorDefinition def : validators) {
                IFacetedProjectValidator validator;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!def.isApplicable(fproj.getProjectFacets()) || (validator = def.getValidator()) == null) continue;
                validator.validate(fproj);
            }
            FacetedProjectValidationBuilder.worked(monitor, 1);
            IProject[] iProjectArray = new IProject[]{};
            return iProjectArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void readExtensions() {
        for (IConfigurationElement config : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            if (!config.getName().equals(EL_VALIDATOR)) continue;
            ValidatorDefinition def = new ValidatorDefinition();
            def.plugin = config.getContributor().getName();
            def.className = config.getAttribute(ATTR_CLASS);
            if (def.className == null) {
                FacetedProjectFrameworkImpl.reportMissingAttribute(config, ATTR_CLASS);
                continue;
            }
            IConfigurationElement[] children = config.getChildren();
            int j = 0;
            while (j < children.length) {
                IConfigurationElement child = children[j];
                String childName = child.getName();
                if (childName.equals(EL_FACET)) {
                    ProjectFacetRef ref = ProjectFacetRef.read(child);
                    if (ref != null) {
                        def.constraints.add(ref);
                    } else {
                        def = null;
                        break;
                    }
                }
                ++j;
            }
            if (def == null) continue;
            validators.add(def);
        }
    }

    private static SubProgressMonitor submon(IProgressMonitor parent, int ticks) {
        if (parent == null) {
            return null;
        }
        return new SubProgressMonitor(parent, ticks);
    }

    private static void worked(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            monitor.worked(ticks);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String taskDescription;

        static {
            Resources.initializeMessages((String)FacetedProjectValidationBuilder.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValidatorDefinition {
        public String plugin;
        public String className;
        public IFacetedProjectValidator validator;
        public final List<ProjectFacetRef> constraints = new ArrayList<ProjectFacetRef>();

        private ValidatorDefinition() {
        }

        public boolean isApplicable(Set<IProjectFacetVersion> facets) throws CoreException {
            for (ProjectFacetRef ref : this.constraints) {
                if (ref.check(facets)) continue;
                return false;
            }
            return true;
        }

        public synchronized IFacetedProjectValidator getValidator() throws CoreException {
            if (this.validator == null) {
                this.validator = PluginUtil.instantiate(this.plugin, this.className, IFacetedProjectValidator.class);
            }
            return this.validator;
        }
    }
}

