/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IPresetFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.PresetDefinition;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultConfigurationPresetFactory
implements IPresetFactory {
    @Override
    public PresetDefinition createPreset(String presetId, Map<String, Object> context) throws CoreException {
        HashSet<IProjectFacetVersion> facets;
        String description;
        String label;
        Set fixed = (Set)context.get("CONTEXT_KEY_FIXED_FACETS");
        if (fixed == null) {
            return null;
        }
        IRuntime runtime = (IRuntime)context.get("CONTEXT_KEY_PRIMARY_RUNTIME");
        if (runtime != null) {
            label = Resources.bind((String)Resources.presetLabel, (Object)runtime.getLocalizedName());
            description = Resources.bind((String)Resources.presetDescription, (Object)runtime.getLocalizedName());
            facets = runtime.getDefaultFacets(fixed);
        } else {
            label = Resources.presetLabelNoRuntime;
            description = Resources.presetDescriptionNoRuntime;
            facets = new HashSet();
            for (IProjectFacet f : fixed) {
                facets.add(f.getDefaultVersion());
            }
        }
        return new PresetDefinition(label, description, facets);
    }

    private static final class Resources
    extends NLS {
        public static String presetLabel;
        public static String presetDescription;
        public static String presetLabelNoRuntime;
        public static String presetDescriptionNoRuntime;

        static {
            Resources.initializeMessages((String)DefaultConfigurationPresetFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

