/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools.wsdlvalidator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.IValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ClassloaderWSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11BasicValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorController;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.http.HTTPValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.mime.MIMEValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.soap.SOAPValidator;
import org.w3c.dom.Document;
import org.wso2.carbon.tools.wsdlvalidator.Report;
import org.wso2.carbon.tools.wsdlvalidator.WSDLValidationInfo;

public class WsdlValidator {
    public static final String WSDL_VALID = "WSDL DOCUMENT IS VALID";
    public static final String WSDL_VALID_I = "WSDL DOCUMENT IS VALID";
    public static final String WSDL_INVALID = " WSDL DOCUMENT IS INVALID";
    public static final String WSDL_INVALID_I = " WSDL DOCUMENT IS INVALID";

    public Report validateFromFile(String type, DataHandler filedata) throws Exception {
        InputStream inputStream;
        try {
            inputStream = filedata.getDataSource().getInputStream();
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        WSDLValidationInfo info1 = this.validaWSDLFromURI(inputStream, null);
        return this.dataPacker(info1);
    }

    public Report validateFromUrl(String type, String url) throws Exception {
        GetMethod httpMethod = new GetMethod(url);
        InputStream inputStream = httpMethod.getResponseBodyAsStream();
        WSDLValidationInfo info2 = this.validaWSDLFromURI(inputStream, url);
        return this.dataPacker(info2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSDLValidationInfo validaWSDLFromURI(InputStream stream, String sourceURL) throws Exception {
        InputStream inputStream = null;
        try {
            DocumentBuilder db;
            URL url;
            if (sourceURL == null) {
                int byteCount;
                File tempFile = File.createTempFile("temp", ".txt");
                tempFile.deleteOnExit();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
                byte[] contentChunk = new byte[1024];
                while ((byteCount = stream.read(contentChunk)) != -1) {
                    out.write(contentChunk, 0, byteCount);
                }
                out.flush();
                url = tempFile.toURI().toURL();
            } else {
                url = new URL(sourceURL);
            }
            inputStream = url.openStream();
            ResourceBundle rb = ResourceBundle.getBundle("validatewsdl");
            MessageGenerator messagegenerator = new MessageGenerator(rb);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                dbf = DocumentBuilderFactory.newInstance();
                db = dbf.newDocumentBuilder();
            }
            Document doc = db.parse(inputStream);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefinition = reader.readWSDL(url.toString());
            ValidationInfoImpl validateInfo = new ValidationInfoImpl(url.toString(), messagegenerator);
            URIResolver uriResolver = new URIResolver();
            validateInfo.setURIResolver(uriResolver);
            WSDL11ValidationInfoImpl info = new WSDL11ValidationInfoImpl((IValidationInfo)validateInfo);
            info.setElementLocations(new Hashtable());
            WSDL11BasicValidator validator = new WSDL11BasicValidator();
            ExtendedWSDL11ValidatorController wsdl11ValidatorController = new ExtendedWSDL11ValidatorController();
            WSDLDocument[] wsdlDocs = wsdl11ValidatorController.readWSDLDocument(doc, validateInfo.getFileURI(), messagegenerator, (IWSDL11ValidationInfo)info);
            WSDLDocument document = wsdlDocs[0];
            List schema = document.getSchemas();
            for (Object aSchema : schema) {
                info.addSchema((XSModel)aSchema);
            }
            info.setElementLocations(document.getElementLocations());
            validator.validate((Object)wsdlDefinition, new ArrayList(), (IWSDL11ValidationInfo)info);
            IValidationMessage[] messages = validateInfo.getValidationMessages();
            WSDLValidationInfo wsdlValidationInfo = new WSDLValidationInfo();
            if (messages.length > 0) {
                wsdlValidationInfo.setStatus(" WSDL DOCUMENT IS INVALID");
            } else {
                wsdlValidationInfo.setStatus("WSDL DOCUMENT IS VALID");
            }
            for (IValidationMessage message : messages) {
                String messageString = "[" + message.getLine() + "][" + message.getColumn() + "]" + message.getMessage();
                wsdlValidationInfo.addValidationMessage(messageString);
            }
            WSDLValidationInfo wSDLValidationInfo = wsdlValidationInfo;
            return wSDLValidationInfo;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private Report dataPacker(WSDLValidationInfo info) {
        Report rpt = new Report();
        ArrayList<String> msg = info.getValidationMessages();
        String[] result = msg.toArray(new String[0]);
        rpt.setResult(result);
        rpt.setStatus(info.getStatus());
        return rpt;
    }

    private static void registerExtensionValidators(ClassLoader classLoader) {
        ClassloaderWSDL11ValidatorDelegate delegate1 = new ClassloaderWSDL11ValidatorDelegate(WSDL11BasicValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/", (WSDL11ValidatorDelegate)delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(HTTPValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/http/", (WSDL11ValidatorDelegate)delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(SOAPValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/soap/", (WSDL11ValidatorDelegate)delegate1);
        delegate1 = new ClassloaderWSDL11ValidatorDelegate(MIMEValidator.class.getName(), classLoader);
        ValidatorRegistry.getInstance().registerValidator("http://schemas.xmlsoap.org/wsdl/mime/", (WSDL11ValidatorDelegate)delegate1);
    }

    private static class ExtendedWSDL11ValidatorController
    extends WSDL11ValidatorController {
        private ExtendedWSDL11ValidatorController() {
        }

        protected WSDLDocument[] readWSDLDocument(Document domModel, String file, MessageGenerator messagegenerator, IWSDL11ValidationInfo wsdlvalinfo) throws ValidateWSDLException {
            return super.readWSDLDocument(domModel, file, messagegenerator, wsdlvalinfo);
        }
    }
}

