/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.Pageable;
import org.wso2.carbon.webapp.mgt.SessionMetadata;
import org.wso2.carbon.webapp.mgt.SessionsWrapper;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebappMetadata;
import org.wso2.carbon.webapp.mgt.WebappStatistics;
import org.wso2.carbon.webapp.mgt.WebappUploadData;
import org.wso2.carbon.webapp.mgt.WebappsWrapper;

public class WebappAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(WebappAdmin.class);

    public WebappAdmin() {
    }

    public WebappAdmin(AxisConfiguration axisConfig) throws Exception {
        super(axisConfig);
    }

    public WebappsWrapper getPagedWebappsSummary(String webappSearchString, String webappState, int pageNumber) throws AxisFault {
        if (webappState.equalsIgnoreCase("started")) {
            return this.getPagedWebapps(pageNumber, this.getStartedWebapps(webappSearchString));
        }
        if (webappState.equalsIgnoreCase("stopped")) {
            return this.getPagedWebapps(pageNumber, this.getStoppedWebapps(webappSearchString));
        }
        throw new AxisFault("Invalid webapp state: ", webappState);
    }

    public WebappMetadata getStartedWebapp(String webappFileName) {
        WebApplicationsHolder holder = this.getWebappsHolder();
        WebApplication webApplication = holder.getStartedWebapps().get(webappFileName);
        WebappMetadata webappMetadata = null;
        if (webApplication != null) {
            webappMetadata = this.getWebapp(webApplication);
            webappMetadata.setStarted(true);
        }
        return webappMetadata;
    }

    public WebappMetadata getStoppedWebapp(String webappFileName) {
        WebApplicationsHolder holder = this.getWebappsHolder();
        WebApplication webApplication = holder.getStoppedWebapps().get(webappFileName);
        WebappMetadata webappMetadata = null;
        if (webApplication != null) {
            webappMetadata = this.getWebapp(webApplication);
            webappMetadata.setStarted(false);
        }
        return webappMetadata;
    }

    private WebappMetadata getWebapp(WebApplication webApplication) {
        WebappMetadata webappMetadata = new WebappMetadata();
        webappMetadata.setDisplayName(webApplication.getDisplayName());
        webappMetadata.setContext(webApplication.getContextName());
        webappMetadata.setLastModifiedTime(webApplication.getLastModifiedTime());
        webappMetadata.setWebappFile(webApplication.getWebappFile().getName());
        webappMetadata.setState(webApplication.getState());
        WebApplication.Statistics statistics = webApplication.getStatistics();
        WebappStatistics stats = new WebappStatistics();
        stats.setActiveSessions(statistics.getActiveSessions());
        stats.setAvgSessionLifetime(statistics.getAvgSessionLifetime());
        stats.setExpiredSessions(statistics.getExpiredSessions());
        stats.setMaxActiveSessions(statistics.getMaxActiveSessions());
        stats.setMaxSessionInactivityInterval(statistics.getMaxSessionInactivityInterval());
        stats.setMaxSessionLifetime(statistics.getMaxSessionLifetime());
        stats.setRejectedSessions(statistics.getRejectedSessions());
        webappMetadata.setStatistics(stats);
        return webappMetadata;
    }

    public WebappsWrapper getPagedFaultyWebappsSummary(String webappSearchString, int pageNumber) throws AxisFault {
        return this.getPagedWebapps(pageNumber, this.getFaultyWebapps(webappSearchString));
    }

    private WebappsWrapper getPagedWebapps(int pageNumber, List<WebappMetadata> webapps) {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        WebappsWrapper webappsWrapper = this.getWebappsWrapper(webappsHolder, webapps);
        try {
            webappsWrapper.setHostName(NetworkUtils.getLocalHostname());
        }
        catch (SocketException e) {
            log.error((Object)"Error occurred while getting local hostname", (Throwable)e);
        }
        if (this.getConfigContext().getAxisConfiguration().getTransportIn("http") != null) {
            int httpProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            if (httpProxyPort != -1) {
                webappsWrapper.setHttpPort(httpProxyPort);
            } else {
                int httpPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"http");
                webappsWrapper.setHttpPort(httpPort);
            }
        }
        if (this.getConfigContext().getAxisConfiguration().getTransportIn("https") != null) {
            int httpsProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"https");
            if (httpsProxyPort != -1) {
                webappsWrapper.setHttpsPort(httpsProxyPort);
            } else {
                int httpsPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"https");
                webappsWrapper.setHttpsPort(httpsPort);
            }
        }
        this.sortWebapps(webapps);
        DataPaginator.doPaging((int)pageNumber, webapps, (Pageable)webappsWrapper);
        return webappsWrapper;
    }

    private void sortWebapps(List<WebappMetadata> webapps) {
        if (webapps.size() > 0) {
            Collections.sort(webapps, new Comparator<WebappMetadata>(){

                @Override
                public int compare(WebappMetadata arg0, WebappMetadata arg1) {
                    return arg0.getContext().compareToIgnoreCase(arg1.getContext());
                }
            });
        }
    }

    private List<WebappMetadata> getStartedWebapps(String webappsSearchString) {
        return this.getWebapps(this.getWebappsHolder().getStartedWebapps().values(), webappsSearchString);
    }

    private List<WebappMetadata> getStoppedWebapps(String webappsSearchString) {
        return this.getWebapps(this.getWebappsHolder().getStoppedWebapps().values(), webappsSearchString);
    }

    private List<WebappMetadata> getWebapps(Collection<WebApplication> allWebapps, String webappsSearchString) {
        ArrayList<WebappMetadata> webapps = new ArrayList<WebappMetadata>();
        for (WebApplication webapp : allWebapps) {
            if (!this.doesWebappSatisfySearchString(webapp, webappsSearchString) || !this.isWebappRelevant(webapp)) continue;
            WebappMetadata webappMetadata = new WebappMetadata();
            webappMetadata.setDisplayName(webapp.getDisplayName());
            webappMetadata.setContext(webapp.getContextName());
            webappMetadata.setLastModifiedTime(webapp.getLastModifiedTime());
            webappMetadata.setWebappFile(webapp.getWebappFile().getName());
            webappMetadata.setState(webapp.getState());
            WebappStatistics statistics = new WebappStatistics();
            statistics.setActiveSessions(webapp.getStatistics().getActiveSessions());
            webappMetadata.setStatistics(statistics);
            webapps.add(webappMetadata);
        }
        return webapps;
    }

    private List<WebappMetadata> getFaultyWebapps(String webappsSearchString) {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        if (webappsHolder == null) {
            return null;
        }
        ArrayList<WebappMetadata> webapps = new ArrayList<WebappMetadata>();
        for (WebApplication webapp : webappsHolder.getFaultyWebapps().values()) {
            if (!this.doesWebappSatisfySearchString(webapp, webappsSearchString)) continue;
            WebappMetadata webappMetadata = new WebappMetadata();
            webappMetadata.setContext(webapp.getContextName());
            webappMetadata.setLastModifiedTime(webapp.getLastModifiedTime());
            webappMetadata.setWebappFile(webapp.getWebappFile().getName());
            webappMetadata.setStarted(false);
            webappMetadata.setRunning(false);
            webappMetadata.setFaulty(true);
            StringWriter sw = new StringWriter();
            webapp.getFaultReason().printStackTrace(new PrintWriter(sw));
            String faultException = sw.toString();
            webappMetadata.setFaultException(faultException);
            webapps.add(webappMetadata);
        }
        return webapps;
    }

    protected boolean doesWebappSatisfySearchString(WebApplication webapp, String searchString) {
        return searchString == null || searchString.trim().length() == 0 || webapp.getContextName().toLowerCase().contains(searchString.toLowerCase());
    }

    private WebApplicationsHolder getWebappsHolder() {
        return (WebApplicationsHolder)this.getConfigContext().getProperty("carbon.webapps.holder");
    }

    private WebappsWrapper getWebappsWrapper(WebApplicationsHolder webappsHolder, List<WebappMetadata> webapps) {
        WebappsWrapper webappsWrapper = new WebappsWrapper();
        webappsWrapper.setWebapps(webapps.toArray(new WebappMetadata[webapps.size()]));
        webappsWrapper.setNumberOfCorrectWebapps(this.getNumberOfWebapps(webappsHolder.getStartedWebapps()));
        webappsWrapper.setNumberOfFaultyWebapps(this.getNumberOfWebapps(webappsHolder.getFaultyWebapps()));
        return webappsWrapper;
    }

    private int getNumberOfWebapps(Map<String, WebApplication> webappMap) {
        int number = 0;
        for (Map.Entry<String, WebApplication> webappEntry : webappMap.entrySet()) {
            if (!this.isWebappRelevant(webappEntry.getValue())) continue;
            ++number;
        }
        return number;
    }

    protected boolean isWebappRelevant(WebApplication webapp) {
        String filterProp = (String)webapp.getProperty("webappFilter");
        return filterProp == null;
    }

    public void deleteStartedWebapps(String[] webappFileNames) throws AxisFault {
        this.deleteWebapps(webappFileNames, this.getWebappsHolder().getStartedWebapps());
    }

    public void deleteStoppedWebapps(String[] webappFileNames) throws AxisFault {
        this.deleteWebapps(webappFileNames, this.getWebappsHolder().getStoppedWebapps());
    }

    public void deleteFaultyWebapps(String[] webappFileNames) throws AxisFault {
        this.deleteWebapps(webappFileNames, this.getWebappsHolder().getFaultyWebapps());
    }

    public void deleteWebapp(String webappFileName) throws AxisFault {
        WebApplicationsHolder holder = this.getWebappsHolder();
        if (holder.getStartedWebapps().get(webappFileName) != null) {
            this.deleteStartedWebapps(new String[]{webappFileName});
        } else if (holder.getStoppedWebapps().get(webappFileName) != null) {
            this.deleteStoppedWebapps(new String[]{webappFileName});
        } else if (holder.getFaultyWebapps().get(webappFileName) != null) {
            this.deleteFaultyWebapps(new String[]{webappFileName});
        }
    }

    private void deleteWebapps(String[] webappFileNames, Map<String, WebApplication> webapps) throws AxisFault {
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            try {
                webapps.remove(webappFileName);
                webapp.delete();
            }
            catch (CarbonException e) {
                this.handleException("Could not delete webapp " + webapp, (Exception)((Object)e));
            }
        }
    }

    private void undeployWebapps(String[] webappFileNames, Map<String, WebApplication> webapps) throws AxisFault {
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            try {
                webapp.undeploy();
                webapps.remove(webappFileName);
            }
            catch (CarbonException e) {
                this.handleException("Could not delete webapp " + webapp, (Exception)((Object)e));
            }
        }
    }

    public void deleteAllStartedWebapps() throws AxisFault {
        this.deleteAllWebapps(this.getWebappsHolder().getStartedWebapps());
    }

    public void deleteAllStoppedWebapps() throws AxisFault {
        this.deleteAllWebapps(this.getWebappsHolder().getStoppedWebapps());
    }

    public void deleteAllFaultyWebapps() throws AxisFault {
        this.deleteAllWebapps(this.getWebappsHolder().getFaultyWebapps());
    }

    private void deleteAllWebapps(Map<String, WebApplication> webapps) throws AxisFault {
        for (WebApplication webapp : webapps.values()) {
            try {
                webapp.delete();
            }
            catch (CarbonException e) {
                this.handleException("Could not delete started webapp " + webapp, (Exception)((Object)e));
            }
        }
        webapps.clear();
    }

    public void reloadAllWebapps() {
        Map<String, WebApplication> startedWebapps = this.getWebappsHolder().getStartedWebapps();
        for (WebApplication webapp : startedWebapps.values()) {
            webapp.reload();
        }
    }

    public void reloadWebapps(String[] webappFileNames) {
        for (String webappFileName : webappFileNames) {
            this.getWebappsHolder().getStartedWebapps().get(webappFileName).reload();
        }
    }

    public void stopAllWebapps() throws AxisFault {
        Map<String, WebApplication> startedWebapps = this.getWebappsHolder().getStartedWebapps();
        for (WebApplication webapp : startedWebapps.values()) {
            try {
                webapp.stop();
            }
            catch (CarbonException e) {
                this.handleException("Error occurred while undeploying all webapps", (Exception)((Object)e));
            }
        }
        startedWebapps.clear();
    }

    public void stopWebapps(String[] webappFileNames) throws AxisFault {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
        for (String webappFileName : webappFileNames) {
            try {
                WebApplication webApplication = startedWebapps.get(webappFileName);
                webappsHolder.stopWebapp(webApplication);
            }
            catch (CarbonException e) {
                this.handleException("Error occurred while undeploying webapps", (Exception)((Object)e));
            }
        }
    }

    public void startAllWebapps() throws AxisFault {
        Map<String, WebApplication> stoppedWebapps = this.getWebappsHolder().getStoppedWebapps();
        Deployer webappDeployer = ((DeploymentEngine)this.getAxisConfig().getConfigurator()).getDeployer("webapps", "war");
        for (WebApplication webapp : stoppedWebapps.values()) {
            this.startWebapp(stoppedWebapps, webapp);
        }
        stoppedWebapps.clear();
    }

    public void startWebapps(String[] webappFileNames) throws AxisFault {
        WebApplicationsHolder webappsHolder = this.getWebappsHolder();
        Map<String, WebApplication> stoppedWebapps = webappsHolder.getStoppedWebapps();
        Deployer webappDeployer = ((DeploymentEngine)this.getAxisConfig().getConfigurator()).getDeployer("webapps", "war");
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = stoppedWebapps.get(webappFileName);
            this.startWebapp(stoppedWebapps, webapp);
        }
    }

    private void startWebapp(Map<String, WebApplication> stoppedWebapps, WebApplication webapp) throws AxisFault {
        try {
            boolean started = webapp.start();
            if (started) {
                String webappFileName = webapp.getWebappFile().getName();
                stoppedWebapps.remove(webappFileName);
                WebApplicationsHolder webappsHolder = this.getWebappsHolder();
                Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
                startedWebapps.put(webappFileName, webapp);
            }
        }
        catch (CarbonException e) {
            String msg = "Cannot start webapp " + webapp;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public SessionsWrapper getActiveSessions(String webappFileName, int pageNumber) {
        WebApplication webapp = this.getWebappsHolder().getStartedWebapps().get(webappFileName);
        ArrayList<SessionMetadata> sessionMetadataList = new ArrayList<SessionMetadata>();
        int numOfActiveSessions = 0;
        if (webapp != null) {
            List<WebApplication.HttpSession> sessions = webapp.getSessions();
            numOfActiveSessions = sessions.size();
            for (WebApplication.HttpSession session : sessions) {
                sessionMetadataList.add(new SessionMetadata(session));
            }
        }
        this.sortSessions(sessionMetadataList);
        SessionsWrapper sessionsWrapper = new SessionsWrapper(sessionMetadataList);
        DataPaginator.doPaging((int)pageNumber, sessionMetadataList, (Pageable)sessionsWrapper);
        sessionsWrapper.setWebappFileName(webappFileName);
        sessionsWrapper.setNumberOfActiveSessions(numOfActiveSessions);
        return sessionsWrapper;
    }

    private void sortSessions(List<SessionMetadata> sessions) {
        if (sessions.size() > 0) {
            Collections.sort(sessions, new Comparator<SessionMetadata>(){

                @Override
                public int compare(SessionMetadata arg0, SessionMetadata arg1) {
                    return (int)(arg0.getLastAccessedTime() - arg1.getLastAccessedTime());
                }
            });
        }
    }

    public void expireSessionsInAllWebapps() {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        for (WebApplication webapp : webapps.values()) {
            webapp.expireAllSessions();
        }
    }

    public void expireSessionsInWebapps(String[] webappFileNames) {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        for (String webappFileName : webappFileNames) {
            WebApplication webapp = webapps.get(webappFileName);
            webapp.expireAllSessions();
        }
    }

    public void expireSessionsInWebapp(String webappFileName, long maxSessionLifetimeMillis) {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        WebApplication webapp = webapps.get(webappFileName);
        webapp.expireSessions(maxSessionLifetimeMillis);
    }

    public void expireSessions(String webappFileName, String[] sessionIDs) throws AxisFault {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        WebApplication webapp = webapps.get(webappFileName);
        try {
            webapp.expireSessions(sessionIDs);
        }
        catch (CarbonException e) {
            this.handleException("Cannot expire specified sessions in webapp " + webappFileName, (Exception)((Object)e));
        }
    }

    public void expireAllSessions(String webappFileName) {
        Map<String, WebApplication> webapps = this.getWebappsHolder().getStartedWebapps();
        WebApplication webapp = webapps.get(webappFileName);
        webapp.expireAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        File webappsDir = new File(this.getWebappDeploymentDirPath());
        if (!webappsDir.exists() && !webappsDir.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDir.getAbsolutePath()));
        }
        for (WebappUploadData uploadData : webappUploadDataList) {
            String fileName = uploadData.getFileName();
            File destFile = new File(webappsDir, fileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(destFile);
                uploadData.getDataHandler().writeTo((OutputStream)fos);
            }
            catch (IOException e) {
                this.handleException("Error occured while uploading the webapp " + fileName, e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.flush();
                        fos.close();
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close file " + destFile.getAbsolutePath()));
                }
            }
        }
        return true;
    }

    protected String getWebappDeploymentDirPath() {
        return this.getAxisConfig().getRepository().getPath() + File.separator + "webapps";
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public DataHandler downloadWarFileHandler(String fileName) {
        String repoPath = this.getWebappDeploymentDirPath() + File.separator + fileName;
        FileDataSource datasource = new FileDataSource(new File(repoPath));
        DataHandler handler = new DataHandler((DataSource)datasource);
        return handler;
    }

    public boolean isUnpackWARs() {
        return TomcatUtil.checkUnpackWars();
    }
}

