/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.lang.management.ManagementPermission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager;
import org.wso2.carbon.utils.multitenancy.CarbonApplicationContextHolder;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionManager;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;

public class TomcatGenericWebappsDeployer {
    private static Log log = LogFactory.getLog(TomcatGenericWebappsDeployer.class);
    protected String webContextPrefix;
    protected int tenantId;
    protected String tenantDomain;
    protected ConfigurationContext configurationContext;
    protected WebApplicationsHolder webappsHolder;
    protected Map<String, CarbonTomcatClusterableSessionManager> sessionManagerMap = new ConcurrentHashMap<String, CarbonTomcatClusterableSessionManager>();

    public TomcatGenericWebappsDeployer(String webContextPrefix, int tenantId, String tenantDomain, WebApplicationsHolder webappsHolder, ConfigurationContext configurationContext) {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.webContextPrefix = webContextPrefix;
        this.webappsHolder = webappsHolder;
        this.configurationContext = configurationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(File webappFile, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String webappName = webappFile.getName();
        CarbonContextHolder currentCarbonContextHolder = CarbonContextHolder.getCurrentCarbonContextHolder();
        currentCarbonContextHolder.startTenantFlow();
        CarbonApplicationContextHolder currentCarbonAppContextHolder = CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder();
        currentCarbonAppContextHolder.startApplicationFlow();
        try {
            currentCarbonContextHolder.setTenantId(this.tenantId);
            currentCarbonContextHolder.setTenantDomain(this.tenantDomain);
            currentCarbonAppContextHolder.setApplicationName(webappName.substring(0, webappName.indexOf(".war")));
            long lastModifiedTime = webappFile.lastModified();
            WebApplication deployedWebapp = this.webappsHolder.getStartedWebapps().get(webappFile.getName());
            WebApplication undeployedWebapp = this.webappsHolder.getStoppedWebapps().get(webappFile.getName());
            WebApplication faultyWebapp = this.webappsHolder.getFaultyWebapps().get(webappFile.getName());
            if (deployedWebapp == null && faultyWebapp == null && undeployedWebapp == null) {
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            } else if (deployedWebapp != null && deployedWebapp.getLastModifiedTime() != lastModifiedTime) {
                this.handleHotUpdate(deployedWebapp, webContextParams, applicationEventListeners);
            } else if (faultyWebapp != null && faultyWebapp.getLastModifiedTime() != lastModifiedTime) {
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            }
        }
        finally {
            currentCarbonAppContextHolder.endApplicationFlow();
            currentCarbonContextHolder.endTenantFlow();
        }
    }

    protected void handleHotDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webapp.getName();
        if (webapp.isDirectory()) {
            if (webapp.list().length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Omitting to deploy empty directory " + webapp.getName() + " as a " + "webapp"));
                }
                return;
            }
            this.handleExplodedWebappDeployment(webapp, webContextParams, applicationEventListeners);
        } else if (filename.endsWith(".war")) {
            this.handleWarWebappDeployment(webapp, webContextParams, applicationEventListeners);
        } else if (filename.endsWith(".zip")) {
            this.handleZipWebappDeployment(webapp, webContextParams, applicationEventListeners);
        }
    }

    protected void handleWarWebappDeployment(File webappWAR, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappWAR.getName();
        String warContext = "";
        if (filename.equals("ROOT.war")) {
            if (this.webContextPrefix != null && !this.webContextPrefix.endsWith("/")) {
                warContext = "/";
            }
        } else {
            warContext = filename.substring(0, filename.indexOf(".war"));
        }
        if (!warContext.equals("/") && this.webContextPrefix.length() == 0) {
            this.webContextPrefix = "/";
        }
        this.handleWebappDeployment(webappWAR, this.webContextPrefix + warContext, webContextParams, applicationEventListeners);
    }

    protected void handleZipWebappDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
    }

    protected void handleExplodedWebappDeployment(File webappDir, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappDir.getName();
        String warContext = "";
        if (filename.equals("ROOT")) {
            if (this.webContextPrefix != null && !this.webContextPrefix.endsWith("/")) {
                warContext = "/";
            }
        } else {
            warContext = filename;
        }
        if (!warContext.equals("/") && this.webContextPrefix.length() == 0) {
            this.webContextPrefix = "/";
        }
        this.handleWebappDeployment(webappDir, this.webContextPrefix + warContext, webContextParams, applicationEventListeners);
    }

    protected void handleWebappDeployment(File webappFile, String contextStr, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappFile.getName();
        try {
            Context context = DataHolder.getCarbonTomcatService().addWebApp(contextStr, webappFile.getAbsolutePath());
            if (DataHolder.getHotUpdateService() != null) {
                List hostNames = DataHolder.getHotUpdateService().getMappigsPerWebapp(contextStr);
                for (String hostName : hostNames) {
                    Host host = (Host)DataHolder.getCarbonTomcatService().getTomcat().getEngine().findChild(hostName);
                    Context contextForHost = DataHolder.getCarbonTomcatService().addWebApp(host, "/", webappFile.getAbsolutePath());
                }
            }
            if (context.getDistributable() && DataHolder.getCarbonTomcatService().getTomcat().getService().getContainer().getCluster() != null) {
                CarbonTomcatClusterableSessionManager sessionManager = new CarbonTomcatClusterableSessionManager(this.tenantId);
                context.setManager((Manager)sessionManager);
                this.sessionManagerMap.put(context.getName(), sessionManager);
                this.configurationContext.setProperty("CarbonTomcatSessionManagerMap", this.sessionManagerMap);
            } else {
                context.setManager((Manager)new CarbonTomcatSessionManager(this.tenantId));
            }
            context.setReloadable(false);
            WebApplication webapp = new WebApplication(context, webappFile);
            webapp.setServletContextParameters(webContextParams);
            webapp.setState("Started");
            this.webappsHolder.getStartedWebapps().put(filename, webapp);
            this.webappsHolder.getFaultyWebapps().remove(filename);
            this.registerApplicationEventListeners(applicationEventListeners, context);
            log.info((Object)("Deployed webapp: " + webapp));
        }
        catch (Throwable e) {
            StandardContext context = new StandardContext();
            context.setName(webappFile.getName());
            WebApplication webapp = new WebApplication((Context)context, webappFile);
            String msg = "Error while deploying webapp: " + webapp;
            log.error((Object)msg, e);
            webapp.setFaultReason(new Exception(msg, e));
            this.webappsHolder.getFaultyWebapps().put(filename, webapp);
            this.webappsHolder.getStartedWebapps().remove(filename);
            throw new CarbonException(msg, e);
        }
    }

    private void registerApplicationEventListeners(List<Object> applicationEventListeners, Context context) {
        Object[] originalEventListeners = context.getApplicationEventListeners();
        Object[] newEventListeners = new Object[originalEventListeners.length + applicationEventListeners.size()];
        if (originalEventListeners.length != 0) {
            System.arraycopy(originalEventListeners, 0, newEventListeners, 0, originalEventListeners.length);
            int i = originalEventListeners.length;
            for (Object eventListener : applicationEventListeners) {
                newEventListeners[i++] = eventListener;
            }
        } else {
            newEventListeners = applicationEventListeners.toArray(new Object[applicationEventListeners.size()]);
        }
        context.setApplicationEventListeners(newEventListeners);
    }

    protected void handleHotUpdate(WebApplication webApplication, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        File webappFile = webApplication.getWebappFile();
        if (webappFile.isDirectory()) {
            webApplication.reload();
            webApplication.setServletContextParameters(webContextParams);
            webApplication.setLastModifiedTime(webappFile.lastModified());
        } else {
            this.undeploy(webApplication);
            this.handleWarWebappDeployment(webappFile, webContextParams, applicationEventListeners);
        }
        log.info((Object)("Redeployed webapp: " + webApplication));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(File webappFile) throws CarbonException {
        CarbonContextHolder currentCarbonContextHolder = CarbonContextHolder.getCurrentCarbonContextHolder();
        currentCarbonContextHolder.startTenantFlow();
        CarbonApplicationContextHolder currentCarbonAppContextHolder = CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder();
        currentCarbonAppContextHolder.startApplicationFlow();
        try {
            currentCarbonContextHolder.setTenantId(this.tenantId);
            currentCarbonContextHolder.setTenantDomain(this.tenantDomain);
            Map<String, WebApplication> deployedWebapps = this.webappsHolder.getStartedWebapps();
            Map<String, WebApplication> stoppedWebapps = this.webappsHolder.getStoppedWebapps();
            String fileName = webappFile.getName();
            currentCarbonAppContextHolder.setApplicationName(fileName.substring(0, fileName.indexOf(".war")));
            if (deployedWebapps.containsKey(fileName)) {
                this.undeploy(deployedWebapps.get(fileName));
            } else if (stoppedWebapps.containsKey(fileName)) {
                this.undeploy(stoppedWebapps.get(fileName));
            }
            this.clearFaultyWebapp(fileName);
        }
        finally {
            currentCarbonAppContextHolder.endApplicationFlow();
            currentCarbonContextHolder.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyUnload(File webappFile) throws CarbonException {
        CarbonContextHolder currentCarbonContextHolder = CarbonContextHolder.getCurrentCarbonContextHolder();
        currentCarbonContextHolder.startTenantFlow();
        CarbonApplicationContextHolder currentCarbonAppContextHolder = CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder();
        currentCarbonAppContextHolder.startApplicationFlow();
        try {
            currentCarbonContextHolder.setTenantId(this.tenantId);
            currentCarbonContextHolder.setTenantDomain(this.tenantDomain);
            Map<String, WebApplication> deployedWebapps = this.webappsHolder.getStartedWebapps();
            String fileName = webappFile.getName();
            currentCarbonAppContextHolder.setApplicationName(fileName.substring(0, fileName.indexOf(".war")));
            if (deployedWebapps.containsKey(fileName)) {
                deployedWebapps.get(fileName).lazyUnload();
            }
            this.clearFaultyWebapp(fileName);
        }
        finally {
            currentCarbonAppContextHolder.endApplicationFlow();
            currentCarbonContextHolder.endTenantFlow();
        }
    }

    private void clearFaultyWebapp(String fileName) {
        Map<String, WebApplication> faultyWebapps = this.webappsHolder.getFaultyWebapps();
        if (faultyWebapps.containsKey(fileName)) {
            WebApplication faultyWebapp = faultyWebapps.get(fileName);
            faultyWebapps.remove(fileName);
            log.info((Object)("Removed faulty webapp " + faultyWebapp));
        }
    }

    private void undeploy(WebApplication webapp) throws CarbonException {
        this.webappsHolder.undeployWebapp(webapp);
        log.info((Object)("Undeployed webapp: " + webapp));
    }
}

