/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.ApplicationContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;

public class TenantLazyLoaderValve
implements CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(TenantLazyLoaderValve.class);

    public void invoke(HttpServletRequest request, HttpServletResponse response) {
        String domain;
        String requestURI = request.getRequestURI();
        String uriOfVirtualHost = ApplicationContext.getCurrentApplicationContext().getApplicationFromUrlMapping(request.getServerName());
        if (uriOfVirtualHost == null) {
            uriOfVirtualHost = DataHolder.getHotUpdateService().getWebappForHost(request.getServerName());
        }
        if (uriOfVirtualHost != null && !uriOfVirtualHost.contains("services")) {
            requestURI = uriOfVirtualHost;
        }
        if ((domain = MultitenantUtils.getTenantDomainFromRequestURL((String)requestURI)) == null || domain.trim().length() == 0) {
            return;
        }
        if (requestURI.indexOf("/webapps/") == -1) {
            return;
        }
        try {
            TenantManager tenantManager = DataHolder.getRealmService().getTenantManager();
            int tenantId = tenantManager.getTenantId(domain);
            if (tenantId == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tenant does not exist: " + domain));
                }
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while checking tenant existence", (Throwable)e);
            return;
        }
        ConfigurationContext serverConfigCtx = DataHolder.getServerConfigContext();
        if (TenantAxisUtils.getLastAccessed((String)domain, (ConfigurationContext)serverConfigCtx) == -1L) {
            try {
                this.setTenantAccessed(domain, serverConfigCtx);
                if (requestURI.indexOf("/webapps/") != -1) {
                    TomcatUtil.remapRequest(request);
                } else {
                    request.getRequestDispatcher(requestURI).forward((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (Exception e) {
                String msg = "Cannot redirect tenant request to " + requestURI + " for tenant " + domain;
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        this.setTenantAccessed(domain, serverConfigCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTenantAccessed(String domain, ConfigurationContext serverConfigCtx) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(TenantLazyLoaderValve.class.getClassLoader());
            TenantAxisUtils.setTenantAccessed((String)domain, (ConfigurationContext)serverConfigCtx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

