/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;

public class GhostWebappDeployerValve
implements CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(GhostWebappDeployerValve.class);

    public void invoke(HttpServletRequest request, HttpServletResponse response) {
        String requestURI;
        if (!GhostWebappDeployerUtils.isGhostOn()) {
            return;
        }
        ConfigurationContext currentCtx = (requestURI = request.getRequestURI()).contains("/t/") ? this.getCurrentConfigurationCtxFromURI(requestURI) : DataHolder.getServerConfigContext();
        WebApplication deployedWebapp = this.getDeployedWebappFromThisURI(requestURI, currentCtx);
        if (deployedWebapp == null) {
            WebApplication transitWebapp = GhostWebappDeployerUtils.dispatchWebAppFromTransitGhosts(requestURI, currentCtx);
            if (transitWebapp != null) {
                String isBeingUnloaded = (String)transitWebapp.getProperty("isBeingUnloaded");
                if (isBeingUnloaded != null && "true".equals(isBeingUnloaded)) {
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    this.handleWebapp(transitWebapp.getWebappFile().getName(), currentCtx);
                } else {
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    try {
                        TomcatUtil.remapRequest(request);
                        return;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
                    }
                }
            }
        } else if (GhostWebappDeployerUtils.isGhostWebApp(deployedWebapp)) {
            this.handleWebapp(deployedWebapp.getWebappFile().getName(), currentCtx);
            try {
                TomcatUtil.remapRequest(request);
                return;
            }
            catch (Exception e) {
                log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
            }
        } else {
            GhostWebappDeployerUtils.updateLastUsedTime(deployedWebapp);
        }
        if (!requestURI.contains("/webapp-mgt/webapp_info.jsp")) {
            return;
        }
        String webappFileName = request.getParameter("webappFileName");
        this.handleWebapp(webappFileName, currentCtx);
    }

    private WebApplication getDeployedWebappFromThisURI(String requestURI, ConfigurationContext cfgCtx) {
        WebApplication deployedWebapp = null;
        WebApplicationsHolder webApplicationsHolder = this.getWebApplicationHolder(cfgCtx);
        for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
            if (!requestURI.contains(webApplication.getContextName())) continue;
            deployedWebapp = webApplication;
        }
        return deployedWebapp;
    }

    private WebApplicationsHolder getWebApplicationHolder(ConfigurationContext cfgCtx) {
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)cfgCtx.getProperty("carbon.webapps.holder");
        return webApplicationsHolder;
    }

    private void handleWebapp(String webappFileName, ConfigurationContext cfgCtx) {
        WebApplication ghostWebapp;
        WebApplicationsHolder webApplicationsHolder;
        if (webappFileName != null && (webApplicationsHolder = this.getWebApplicationHolder(cfgCtx)) != null && (ghostWebapp = webApplicationsHolder.getStartedWebapps().get(webappFileName)) != null) {
            GhostWebappDeployerUtils.deployActualWebApp(ghostWebapp, cfgCtx);
        }
    }

    private ConfigurationContext getCurrentConfigurationCtxFromURI(String uri) {
        return TenantAxisUtils.getTenantConfigurationContextFromUrl((String)uri, (ConfigurationContext)DataHolder.getServerConfigContext());
    }
}

