/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.validate.domain.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.validate.domain.util.Util;

public class ValidateDomainService {
    private static final Log log = LogFactory.getLog(ValidateDomainService.class);

    public String getDomainValidationKey(String domain) throws Exception {
        return Util.getDomainValidationKeyWithoutLogin(domain);
    }

    public String validateByDNSEntry(String domain) throws Exception {
        return Util.validateByDNSEntry(domain);
    }

    public String validateByTextInRoot(String domain) throws Exception {
        if (!Util.checkDomainAvailability(domain)) {
            String msg = "Domain " + domain + " is already taken.";
            log.info((Object)msg);
            return "unavailable";
        }
        return Util.validateByTextInRoot(domain);
    }
}

