/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.validate.domain.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.validate.domain.stub.services.ValidateDomainAdminServiceStub;
import org.wso2.carbon.validate.domain.ui.clients.ValidateDomainClient;

public class ValidateDomainAdminClient
implements ValidateDomainClient {
    private static final Log log = LogFactory.getLog(ValidateDomainAdminClient.class);
    private ValidateDomainAdminServiceStub stub;
    private String epr;

    public ValidateDomainAdminClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ValidateDomainAdminService";
        try {
            this.stub = new ValidateDomainAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Validate Domain service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ValidateDomainAdminClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ValidateDomainAdminService";
        try {
            this.stub = new ValidateDomainAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String getDomainValidationKey(String domain) throws RegistryException {
        try {
            return this.stub.getDomainValidationKey(domain);
        }
        catch (Exception e) {
            String msg = "Failed to get domain validation keys. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public String validateByDNSEntry(String domain) throws RegistryException {
        try {
            return this.stub.validateByDNSEntry(domain);
        }
        catch (Exception e) {
            String msg = "Failed to validate by dns entry. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public String validateByTextInRoot(String domain) throws RegistryException {
        try {
            return this.stub.validateByTextInRoot(domain);
        }
        catch (Exception e) {
            String msg = "Failed to validate by dns entry. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

