/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.dispatchers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class GhostDispatcher
extends AbstractDispatcher {
    private static Log log = LogFactory.getLog(GhostDispatcher.class);
    private static final String NAME = "GhostDispatcher";

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        if (msgctx.getAxisService() == null) {
            AxisService transitService = GhostDeployerUtils.dispatchServiceFromTransitGhosts(msgctx);
            if (transitService != null) {
                Parameter isUnloadingParam = transitService.getParameter("isBeingUnloaded");
                if (isUnloadingParam != null && "true".equals(isUnloadingParam.getValue())) {
                    GhostDeployerUtils.waitForServiceToLeaveTransit(transitService.getName(), msgctx.getConfigurationContext().getAxisConfiguration());
                    this.findServiceAndOperation(transitService.getName(), msgctx);
                } else {
                    GhostDeployerUtils.waitForServiceToLeaveTransit(transitService.getName(), msgctx.getConfigurationContext().getAxisConfiguration());
                }
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        AxisService service = this.findService(msgctx);
        if (service != null) {
            this.findOperation(service, msgctx);
        }
        if (msgctx.getAxisService() != null) {
            GhostDeployerUtils.updateLastUsedTime(msgctx.getAxisService());
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) {
        AxisOperation existingOperation;
        AxisOperation newOperation = null;
        if (service != null && messageContext.getAxisOperation() != null && (newOperation = service.getOperation((existingOperation = messageContext.getAxisOperation()).getName())) != null) {
            messageContext.setAxisOperation(newOperation);
        }
        return newOperation;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        AxisService dispatchedService = messageContext.getAxisService();
        AxisService newService = null;
        if (GhostDeployerUtils.isGhostService(dispatchedService)) {
            AxisConfiguration axisConfig = messageContext.getConfigurationContext().getAxisConfiguration();
            try {
                newService = GhostDeployerUtils.deployActualService(axisConfig, dispatchedService);
            }
            catch (AxisFault e) {
                log.error((Object)"Error deploying service. ", (Throwable)e);
                throw e;
            }
            if (newService != null) {
                messageContext.setAxisService(newService);
                messageContext.removeProperty("AxisBindingMessage");
            }
        }
        return newService;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private void findServiceAndOperation(String serviceName, MessageContext msgctx) throws AxisFault {
        AxisService newService = null;
        AxisConfiguration axisConfig = msgctx.getConfigurationContext().getAxisConfiguration();
        AxisService ghostService = axisConfig.getService(serviceName);
        Parameter dispatchedGhostParam = ghostService.getParameter("GhostService");
        if (dispatchedGhostParam != null && "true".equals(dispatchedGhostParam.getValue()) && (newService = GhostDeployerUtils.deployActualService(axisConfig, ghostService)) != null) {
            msgctx.setAxisService(newService);
            msgctx.removeProperty("AxisBindingMessage");
        }
        if (newService != null) {
            this.findOperation(newService, msgctx);
        }
        if (msgctx.getAxisService() != null) {
            GhostDeployerUtils.updateLastUsedTime(msgctx.getAxisService());
        }
    }
}

