/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.multitenancy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.CarbonApplicationContextHolderBase;

public class CarbonApplicationContextHolder {
    private CarbonApplicationContextHolderBase carbonAppContextHolderBase;
    private static final String CARBON_APPLICATION_CONTEXT_HOLDER = "carbonApplicationContextHolder";
    private static final Log log = LogFactory.getLog(CarbonApplicationContextHolder.class);

    private CarbonApplicationContextHolderBase getCarbonAppContextHolderBase() {
        if (this.carbonAppContextHolderBase == null) {
            return CarbonApplicationContextHolderBase.getCurrentCarbonAppContextHolderBase();
        }
        return this.carbonAppContextHolderBase;
    }

    public static void destroyCurrentCarbonAppContextHolder() {
        CarbonApplicationContextHolderBase.destroyCurrentCarbonaAppContextHolder();
    }

    public void startApplicationFlow() {
        this.getCarbonAppContextHolderBase().startApplicationFlow();
    }

    public void endApplicationFlow() {
        this.getCarbonAppContextHolderBase().endApplicationFlow();
    }

    private CarbonApplicationContextHolder(CarbonApplicationContextHolderBase carbonAppContextHolderBase) {
        this.carbonAppContextHolderBase = carbonAppContextHolderBase;
    }

    private CarbonApplicationContextHolder() {
        this(null);
    }

    private static CarbonApplicationContextHolder getClone() {
        return new CarbonApplicationContextHolder(new CarbonApplicationContextHolderBase(CarbonApplicationContextHolderBase.getCurrentCarbonAppContextHolderBase()));
    }

    public static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(ConfigurationContext configurationContext) {
        return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(configurationContext, true);
    }

    private static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(ConfigurationContext configurationContext, boolean addToConfigContext) {
        if (configurationContext != null && configurationContext.getAxisConfiguration() != null) {
            return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(configurationContext.getAxisConfiguration(), addToConfigContext);
        }
        return CarbonApplicationContextHolder.getThreadLocalCarbonApplicationContextHolder();
    }

    public static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(AxisConfiguration axisConfiguration) {
        return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(axisConfiguration, true);
    }

    private static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(AxisConfiguration axisConfiguration, boolean addToConfiguration) {
        Parameter param = axisConfiguration.getParameter(CARBON_APPLICATION_CONTEXT_HOLDER);
        if (param != null && param.getValue() != null) {
            return (CarbonApplicationContextHolder)param.getValue();
        }
        if (!addToConfiguration) {
            return null;
        }
        try {
            CarbonApplicationContextHolder context = CarbonApplicationContextHolder.getClone();
            log.debug((Object)"Added CarbonApplicationContext to the Axis Configuration");
            axisConfiguration.addParameter(CARBON_APPLICATION_CONTEXT_HOLDER, (Object)context);
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add CarbonApplicationContext to the AxisConfiguration.", e);
        }
    }

    public static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(HttpSession httpSession) {
        return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(httpSession, true);
    }

    private static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(HttpSession httpSession, boolean addToSession) {
        Object contextObject = httpSession.getAttribute(CARBON_APPLICATION_CONTEXT_HOLDER);
        if (contextObject != null) {
            return (CarbonApplicationContextHolder)contextObject;
        }
        if (!addToSession) {
            return null;
        }
        CarbonApplicationContextHolder context = CarbonApplicationContextHolder.getClone();
        log.debug((Object)"Added CarbonContext to the HTTP Session");
        httpSession.setAttribute(CARBON_APPLICATION_CONTEXT_HOLDER, (Object)context);
        return context;
    }

    public static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder(MessageContext messageContext) {
        HttpSession httpSession;
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null && (httpSession = request.getSession(false)) != null) {
            CarbonApplicationContextHolder context = CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(httpSession, false);
            if (context != null) {
                return context;
            }
            if (messageContext.getConfigurationContext() != null && (context = CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(messageContext.getConfigurationContext(), false)) != null) {
                return context;
            }
            context = CarbonApplicationContextHolder.getClone();
            log.debug((Object)"Added CarbonContext to the HTTP Session");
            httpSession.setAttribute(CARBON_APPLICATION_CONTEXT_HOLDER, (Object)context);
            return context;
        }
        return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(messageContext.getConfigurationContext());
    }

    public static CarbonApplicationContextHolder getCurrentCarbonAppContextHolder() {
        try {
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            if (messageContext != null) {
                return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder(messageContext);
            }
            return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder((ConfigurationContext)null);
        }
        catch (NullPointerException ignore) {
            return CarbonApplicationContextHolder.getThreadLocalCarbonApplicationContextHolder();
        }
        catch (NoClassDefFoundError ignore) {
            return CarbonApplicationContextHolder.getThreadLocalCarbonApplicationContextHolder();
        }
    }

    public static CarbonApplicationContextHolder getThreadLocalCarbonApplicationContextHolder() {
        return new CarbonApplicationContextHolder();
    }

    public String getApplicationName() {
        return this.getCarbonAppContextHolderBase().getApplicationName();
    }

    public void setApplicationName(String applicationName) {
        this.getCarbonAppContextHolderBase().setApplicationName(applicationName);
    }
}

