/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;

public class GhostDeployerUtils {
    private static final String PARAMETER_VALUE_TRUE = "true";
    private static Log log = LogFactory.getLog(GhostDeployerUtils.class);
    public static final String ENABLE_GHOST_DEPLOYER = "EnableGhostDeployer";
    private static final String TRANSIT_GHOST_SERVICE_MAP = "TransitGhostServiceMap";

    private GhostDeployerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AxisService deployActualService(AxisConfiguration axisConfig, AxisService ghostService) throws AxisFault {
        AxisService newService = null;
        String string = ghostService.getName().intern();
        synchronized (string) {
            String serviceName = ghostService.getName();
            AxisService axisConfigService = axisConfig.getService(serviceName);
            if (axisConfigService == null) {
                return null;
            }
            Parameter actualGhostParam = axisConfigService.getParameter("GhostService");
            if (actualGhostParam == null || "false".equals(actualGhostParam.getValue())) {
                newService = axisConfigService;
            } else {
                GhostDeployer ghostDeployer = GhostDeployerUtils.getGhostDeployer(axisConfig);
                if (ghostDeployer == null) {
                    return null;
                }
                DeploymentFileData dfd = ghostDeployer.getFileData(axisConfigService.getFileName().getPath());
                if (dfd != null) {
                    log.info((Object)("Removing Ghost Service and loading actual service : " + serviceName));
                    AxisServiceGroup existingSG = (AxisServiceGroup)axisConfigService.getParent();
                    existingSG.addParameter("keepServiceHistory", (Object)PARAMETER_VALUE_TRUE);
                    Map<String, AxisService> transitGhostList = GhostDeployerUtils.getTransitGhostServicesMap(axisConfig);
                    Iterator servicesItr = existingSG.getServices();
                    while (servicesItr.hasNext()) {
                        AxisService service = (AxisService)servicesItr.next();
                        transitGhostList.put(service.getName(), service);
                    }
                    String serviceGroupName = existingSG.getServiceGroupName();
                    if (axisConfig.getServiceGroup(serviceGroupName) != null) {
                        axisConfig.removeServiceGroup(serviceGroupName);
                    } else {
                        axisConfig.removeService(serviceName);
                    }
                    dfd.deploy();
                    newService = axisConfig.getService(serviceName);
                    AxisServiceGroup newSG = (AxisServiceGroup)newService.getParent();
                    Iterator servicesItr2 = newSG.getServices();
                    while (servicesItr2.hasNext()) {
                        AxisService service = (AxisService)servicesItr2.next();
                        transitGhostList.remove(service.getName());
                    }
                }
            }
            GhostDeployerUtils.updateLastUsedTime(newService);
        }
        return newService;
    }

    public static void updateLastUsedTime(AxisService service) {
        if (service == null) {
            return;
        }
        try {
            Parameter lastUsageParam = service.getParameter("lastUsedTime");
            if (lastUsageParam == null) {
                lastUsageParam = new Parameter();
                lastUsageParam.setName("lastUsedTime");
                service.addParameter(lastUsageParam);
            }
            lastUsageParam.setValue((Object)System.currentTimeMillis());
        }
        catch (Exception e) {
            log.error((Object)("Error while updating lastUsedTime parameter in service : " + service.getName()), (Throwable)e);
        }
    }

    public static GhostDeployer getGhostDeployer(AxisConfiguration axisConfig) {
        GhostDeployer ghostDeployer = null;
        Parameter param = axisConfig.getParameter("ghostDeployer");
        if (param != null) {
            return (GhostDeployer)((Object)param.getValue());
        }
        return ghostDeployer;
    }

    public static boolean isGhostOn() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String ghostOn = serverConfig.getFirstProperty(ENABLE_GHOST_DEPLOYER);
        return ghostOn != null && Boolean.parseBoolean(ghostOn);
    }

    public static synchronized Map<String, AxisService> getTransitGhostServicesMap(AxisConfiguration axisConfig) throws AxisFault {
        Parameter param = axisConfig.getParameter(TRANSIT_GHOST_SERVICE_MAP);
        HashMap transitMap = null;
        if (param != null) {
            transitMap = (HashMap)param.getValue();
        }
        if (transitMap == null) {
            transitMap = new HashMap();
            axisConfig.addParameter(TRANSIT_GHOST_SERVICE_MAP, transitMap);
        }
        return transitMap;
    }

    public static AxisService dispatchServiceFromTransitGhosts(MessageContext msgCtx) throws AxisFault {
        String filePart;
        String serviceOpPart;
        AxisService actualService = null;
        Map<String, AxisService> transitGhostMap = GhostDeployerUtils.getTransitGhostServicesMap(msgCtx.getConfigurationContext().getAxisConfiguration());
        EndpointReference toEPR = msgCtx.getTo();
        if (toEPR != null && (serviceOpPart = Utils.getServiceAndOperationPart((String)(filePart = toEPR.getAddress()), (String)msgCtx.getConfigurationContext().getServiceContextPath())) != null) {
            int index = serviceOpPart.indexOf(46);
            if (index != -1) {
                serviceOpPart = serviceOpPart.substring(0, index);
            }
            String[] parts = serviceOpPart.split("/");
            String tmpServiceName = "";
            for (int count = 0; actualService == null && count < parts.length && count < Constants.MAX_HIERARCHICAL_DEPTH; ++count) {
                String string = tmpServiceName = count == 0 ? tmpServiceName + parts[count] : tmpServiceName + "/" + parts[count];
                if (!transitGhostMap.containsKey(tmpServiceName)) continue;
                actualService = transitGhostMap.get(tmpServiceName);
            }
        }
        return actualService;
    }

    public static void waitForServiceToLeaveTransit(String serviceName, AxisConfiguration axisConfig) throws AxisFault {
        Map<String, AxisService> transitGhostMap = GhostDeployerUtils.getTransitGhostServicesMap(axisConfig);
        while (transitGhostMap.containsKey(serviceName)) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isGhostService(AxisService axisService) {
        if (axisService == null) {
            return false;
        }
        Parameter ghostParam = axisService.getParameter("GhostService");
        return ghostParam != null && PARAMETER_VALUE_TRUE.equals(ghostParam.getValue());
    }

    public static AxisServiceGroup createGhostServiceGroup(AxisConfiguration axisConfig, File ghostFile, URL originalFile) {
        OMElement serviceGroupElm;
        try {
            FileInputStream xmlInputStream = new FileInputStream(ghostFile);
            serviceGroupElm = new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing ghost XML file : " + ghostFile.getAbsolutePath()));
            return null;
        }
        AxisServiceGroup ghostGroup = new AxisServiceGroup(axisConfig);
        ghostGroup.setServiceGroupName(serviceGroupElm.getAttributeValue(new QName("name")));
        try {
            Iterator itr = serviceGroupElm.getChildrenWithLocalName("service");
            while (itr.hasNext()) {
                OMElement endpointsElm;
                String secScenario;
                OMElement serviceElm = (OMElement)itr.next();
                AxisService ghostService = new AxisService(serviceElm.getAttributeValue(new QName("name")));
                ghostService.addParameter(new Parameter("GhostService", (Object)PARAMETER_VALUE_TRUE));
                String serviceType = serviceElm.getAttributeValue(new QName("serviceType"));
                if (serviceType != null) {
                    ghostService.addParameter(new Parameter("serviceType", (Object)serviceType));
                }
                if ((secScenario = serviceElm.getAttributeValue(new QName("securityScenario"))) != null) {
                    ghostService.addParameter(new Parameter("securityScenario", (Object)secScenario));
                }
                ghostService.setFileName(originalFile);
                OMElement operationsElm = serviceElm.getFirstChildWithName(new QName("operations"));
                if (operationsElm != null) {
                    Iterator operationItr = operationsElm.getChildren();
                    while (operationItr.hasNext()) {
                        OMElement opElm = (OMElement)operationItr.next();
                        AxisOperation newOp = AxisOperationFactory.getOperationDescription((String)opElm.getAttributeValue(new QName("mep")));
                        String ns = opElm.getNamespace() == null ? "" : opElm.getNamespace().getNamespaceURI();
                        newOp.setName(new QName(ns, opElm.getLocalName()));
                        ghostService.addOperation(newOp);
                    }
                }
                if ((endpointsElm = serviceElm.getFirstChildWithName(new QName("endpoints"))) != null) {
                    Iterator endpointItr = endpointsElm.getChildren();
                    while (endpointItr.hasNext()) {
                        OMElement epElm = (OMElement)endpointItr.next();
                        AxisEndpoint axisEndpoint = new AxisEndpoint();
                        axisEndpoint.setBinding(new AxisBinding());
                        axisEndpoint.setName(epElm.getLocalName());
                        ghostService.addEndpoint(epElm.getLocalName(), axisEndpoint);
                    }
                }
                ghostGroup.addService(ghostService);
            }
            ghostGroup.addParameter(new Parameter("GhostService", (Object)PARAMETER_VALUE_TRUE));
        }
        catch (Exception e) {
            log.error((Object)("Error while creating Ghost Service from Ghost File : " + ghostFile.getAbsolutePath()), (Throwable)e);
        }
        return ghostGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeServiceGroup(AxisServiceGroup serviceGroup, AxisConfiguration axisConfig, String servicePath) {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement serviceGroupEle = omFactory.createOMElement(new QName("serviceGroup"));
        serviceGroupEle.addAttribute("name", serviceGroup.getServiceGroupName(), null);
        Iterator services = serviceGroup.getServices();
        while (services.hasNext()) {
            AxisService service = (AxisService)services.next();
            OMElement serviceEle = omFactory.createOMElement(new QName("service"));
            serviceGroupEle.addChild((OMNode)serviceEle);
            serviceEle.addAttribute("name", service.getName(), null);
            String serviceType = null;
            Parameter serviceTypeParam = service.getParameter("serviceType");
            if (serviceTypeParam != null) {
                serviceType = (String)serviceTypeParam.getValue();
            }
            if (serviceType != null) {
                serviceEle.addAttribute("serviceType", serviceType, null);
            }
            OMElement operations = omFactory.createOMElement(new QName("operations"));
            serviceEle.addChild((OMNode)operations);
            Iterator ops = service.getOperations();
            while (ops.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)ops.next();
                OMElement opElement = omFactory.createOMElement(axisOperation.getName());
                opElement.addAttribute("mep", axisOperation.getMessageExchangePattern(), null);
                operations.addChild((OMNode)opElement);
            }
            OMElement endpoints = omFactory.createOMElement(new QName("endpoints"));
            serviceEle.addChild((OMNode)endpoints);
            for (AxisEndpoint endpoint : service.getEndpoints().values()) {
                endpoints.addChild((OMNode)omFactory.createOMElement(new QName(endpoint.getName())));
            }
        }
        String tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath(axisConfig);
        if (tenantTmpDirPath == null) {
            return;
        }
        String ghostPath = tenantTmpDirPath + File.separator + "ghostServices";
        File ghostFolder = new File(ghostPath);
        if (!ghostFolder.exists() && !ghostFolder.mkdir()) {
            log.error((Object)("Error while creating ghostServices folder at : " + ghostPath));
            return;
        }
        FileOutputStream fos = null;
        try {
            String ghostFileName = GhostDeployerUtils.calculateGhostFileName(servicePath, axisConfig.getRepository().getPath());
            if (ghostFileName == null) {
                log.error((Object)("Ghost file name is null. Actual service path : " + servicePath));
                return;
            }
            File serviceFile = new File(ghostPath + File.separator + ghostFileName);
            fos = new FileOutputStream(serviceFile);
            serviceGroupEle.serialize((OutputStream)fos);
            fos.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error while serializing OMElement for Ghost Service", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the file output stream", (Throwable)e);
                }
            }
        }
    }

    public static String calculateGhostFileName(String fileName, String repoPath) {
        String ghostFileName = null;
        if (fileName != null && fileName.startsWith(repoPath)) {
            ghostFileName = fileName.substring(repoPath.length());
            if (ghostFileName.lastIndexOf(46) != -1) {
                ghostFileName = ghostFileName.substring(0, ghostFileName.lastIndexOf(46));
            }
            if (File.separatorChar == '\\') {
                ghostFileName = ghostFileName.replace('\\', '/');
            }
            ghostFileName = ghostFileName.replace('/', '_');
            ghostFileName = ghostFileName + ".xml";
        }
        return ghostFileName;
    }

    public static File getGhostFile(String fileName, AxisConfiguration axisConfig) {
        String tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath(axisConfig);
        String ghostFileName = GhostDeployerUtils.calculateGhostFileName(fileName, axisConfig.getRepository().getPath());
        if (tenantTmpDirPath != null && ghostFileName != null) {
            return new File(tenantTmpDirPath + File.separator + "ghostServices" + File.separator + ghostFileName);
        }
        return null;
    }

    public static void addServiceGroupToTransitMap(AxisServiceGroup serviceGroup, AxisConfiguration axisConfig) throws AxisFault {
        Map<String, AxisService> transitGhostList = GhostDeployerUtils.getTransitGhostServicesMap(axisConfig);
        Iterator servicesItr = serviceGroup.getServices();
        while (servicesItr.hasNext()) {
            AxisService service = (AxisService)servicesItr.next();
            transitGhostList.put(service.getName(), service);
        }
    }

    public static void removeServiceGroupFromTransitMap(AxisServiceGroup serviceGroup, AxisConfiguration axisConfig) throws AxisFault {
        Map<String, AxisService> transitGhostList = GhostDeployerUtils.getTransitGhostServicesMap(axisConfig);
        Iterator servicesItr = serviceGroup.getServices();
        while (servicesItr.hasNext()) {
            AxisService service = (AxisService)servicesItr.next();
            transitGhostList.remove(service.getName());
        }
    }
}

