/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceDeployer;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class GhostDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(GhostDeployer.class);
    private Map<String, Map<String, Deployer>> deployerMap = new HashMap<String, Map<String, Deployer>>();
    private List<DeploymentFileData> deploymentData = new ArrayList<DeploymentFileData>();
    private Lock deployerLock = new ReentrantLock();
    private Lock fileDataLock = new ReentrantLock();
    private boolean initialized = false;
    private boolean cleanedUp = false;
    private static final String DIRECTORY_DEPLOYER_KEY = ".";
    private AxisConfiguration axisConfig = null;
    private ConfigurationContext configCtx = null;

    public void init(ConfigurationContext configCtx) {
        if (this.initialized) {
            return;
        }
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        this.addDeployer((Deployer)new ServiceDeployer(), CarbonUtils.getAxis2ServicesDir(this.axisConfig), ".aar");
        for (Map<String, Deployer> extensionMap : this.deployerMap.values()) {
            for (Deployer deployer : extensionMap.values()) {
                deployer.init(configCtx);
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String absoluteFilePath = deploymentFileData.getAbsolutePath();
        String directoryName = this.calculateDirectoryName(absoluteFilePath);
        if (!"servicemetafiles".equals(directoryName) && !"modulemetafiles".equals(directoryName)) {
            log.info((Object)("Ghost Deployer Deploying Artifact : " + absoluteFilePath));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Ghost Deployer Deploying Artifact : " + absoluteFilePath));
        }
        String fileExtension = this.getFileExtension(deploymentFileData.getName());
        Deployer deployer = this.getDeployer(directoryName, fileExtension);
        if (deployer == null) {
            log.error((Object)("Matching deployer can't be found for the deployment file : " + absoluteFilePath));
            return;
        }
        deploymentFileData.setDeployer(deployer);
        File ghostFile = GhostDeployerUtils.getGhostFile(absoluteFilePath, this.axisConfig);
        if (ghostFile == null || !ghostFile.exists()) {
            deploymentFileData.deploy();
            Set services = this.axisConfig.getServices().entrySet();
            for (Map.Entry entry : services) {
                AxisService service = (AxisService)entry.getValue();
                if (CarbonUtils.isFilteredOutService(service) || service.getFileName() == null || !service.getFileName().getPath().equals(absoluteFilePath)) continue;
                GhostDeployerUtils.updateLastUsedTime(service);
                try {
                    GhostDeployerUtils.serializeServiceGroup((AxisServiceGroup)service.getParent(), this.axisConfig, absoluteFilePath);
                }
                catch (Exception ex) {
                    log.error((Object)("Error while adding parameter into service : " + service.getName()), (Throwable)ex);
                }
                break;
            }
        } else {
            try {
                AxisServiceGroup ghostServiceGroup = GhostDeployerUtils.createGhostServiceGroup(this.axisConfig, ghostFile, deploymentFileData.getFile().toURI().toURL());
                this.axisConfig.addServiceGroup(ghostServiceGroup);
            }
            catch (Exception e) {
                String msg = "Error while loading the Ghost Service : " + ghostFile.getAbsolutePath();
                log.error((Object)msg, (Throwable)e);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
        this.fileDataLock.lock();
        try {
            this.deploymentData.add(deploymentFileData);
        }
        finally {
            this.fileDataLock.unlock();
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        log.info((Object)("Undeploying file : " + fileName));
        if (fileName == null) {
            return;
        }
        File ghostFile = GhostDeployerUtils.getGhostFile(fileName, this.axisConfig);
        if (ghostFile != null && ghostFile.exists() && !ghostFile.delete()) {
            log.error((Object)("Error while deleting ghost service file : " + ghostFile.getAbsolutePath()));
        }
        this.removeFileData(fileName);
        if (fileName.lastIndexOf(46) != -1) {
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            Deployer deployer = this.getDeployer(this.calculateDirectoryName(fileName), extension);
            if (deployer != null) {
                deployer.undeploy(fileName);
            }
        }
    }

    public void cleanup() throws DeploymentException {
        if (this.cleanedUp) {
            return;
        }
        for (Map<String, Deployer> extensionMap : this.deployerMap.values()) {
            for (Deployer deployer : extensionMap.values()) {
                try {
                    deployer.cleanup();
                }
                catch (DeploymentException e) {
                    log.error((Object)"Error occurred while cleaning up deployer", (Throwable)e);
                }
            }
        }
        this.cleanedUp = true;
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public DeploymentFileData getFileData(String fileName) {
        for (DeploymentFileData data : this.deploymentData) {
            if (!fileName.equals(data.getFile().getPath())) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileData(DeploymentFileData fileData) {
        this.fileDataLock.lock();
        try {
            this.deploymentData.remove(fileData);
        }
        finally {
            this.fileDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileData(String filePath) {
        if (filePath == null) {
            return;
        }
        this.fileDataLock.lock();
        try {
            DeploymentFileData dataToRemove = null;
            for (DeploymentFileData d : this.deploymentData) {
                if (!filePath.equals(d.getAbsolutePath())) continue;
                dataToRemove = d;
                break;
            }
            if (dataToRemove != null) {
                this.deploymentData.remove(dataToRemove);
            }
        }
        finally {
            this.fileDataLock.unlock();
        }
    }

    public Deployer getDeployer(String directory, String extension) {
        Map<String, Deployer> extensionMap = this.deployerMap.get(directory);
        if (extension == null) {
            extension = DIRECTORY_DEPLOYER_KEY;
        }
        return extensionMap != null ? extensionMap.get(extension) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployer(Deployer deployer, String directory, String extension) {
        String deployerKey;
        if (deployer == null || directory == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to add Deployer : Couldn't find needed information..");
            }
            return;
        }
        if (extension == null) {
            deployerKey = DIRECTORY_DEPLOYER_KEY;
        } else {
            deployerKey = extension;
            if (extension.charAt(0) == '.') {
                deployerKey = extension.substring(1);
            }
        }
        if (this.initialized) {
            deployer.init(this.configCtx);
        }
        this.deployerLock.lock();
        try {
            Map<String, Deployer> extensionMap = this.deployerMap.get(directory);
            if (extensionMap == null) {
                extensionMap = new HashMap<String, Deployer>();
                this.deployerMap.put(directory, extensionMap);
            }
            extensionMap.put(deployerKey, deployer);
        }
        finally {
            this.deployerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployer(String directory, String extension) {
        Map<String, Deployer> extensionMap;
        if (directory == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to remove Deployer : Couldn't find needed information..");
            }
            return;
        }
        if (extension == null) {
            extension = DIRECTORY_DEPLOYER_KEY;
        }
        if ((extensionMap = this.deployerMap.get(directory)) == null) {
            return;
        }
        this.deployerLock.lock();
        try {
            if (extensionMap.containsKey(extension)) {
                Deployer deployer = extensionMap.remove(extension);
                if (extensionMap.isEmpty()) {
                    this.deployerMap.remove(directory);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deployer " + deployer.getClass().getName() + " is removed"));
                }
            }
        }
        finally {
            this.deployerLock.unlock();
        }
    }

    private String calculateDirectoryName(String servicePath) {
        String repoPath = this.axisConfig.getRepository().getPath();
        String dirName = null;
        if (servicePath != null && servicePath.startsWith(repoPath)) {
            dirName = servicePath.substring(repoPath.length());
            if (dirName.startsWith(File.separator)) {
                dirName = dirName.substring(1);
            }
            if (dirName.indexOf(File.separator) != -1) {
                dirName = dirName.substring(0, dirName.indexOf(File.separator));
            }
        }
        return dirName;
    }

    private String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return index != -1 ? fileName.substring(index + 1) : null;
    }
}

