/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserStoreInfo;
import org.wso2.carbon.user.mgt.ui.PaginatedNamesBean;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;

public class Util {
    public static org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName[] toADBFlaggedNames(FlaggedName[] flaggedNames) {
        if (flaggedNames == null) {
            return new org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName[0];
        }
        org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName[] names = new org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName[flaggedNames.length];
        int i = 0;
        for (FlaggedName fName : flaggedNames) {
            org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName name = new org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName();
            name.setItemName(fName.getItemName());
            name.setEditable(fName.isEditable());
            name.setSelected(fName.isSelected());
            names[i] = name;
            ++i;
        }
        return names;
    }

    public static FlaggedName[] toCommonFlaggedNames(org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName[] flaggedNames) {
        if (flaggedNames == null) {
            return new FlaggedName[0];
        }
        FlaggedName[] names = new FlaggedName[flaggedNames.length];
        int i = 0;
        for (org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName fName : flaggedNames) {
            FlaggedName name = new FlaggedName();
            name.setItemName(fName.getItemName());
            name.setSelected(fName.getSelected());
            name.setEditable(fName.getEditable());
            name.setRoleType(fName.getRoleType());
            names[i] = name;
            ++i;
        }
        return names;
    }

    public static org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue[] toADBClaimValues(ClaimValue[] claimValues) {
        if (claimValues == null) {
            return new org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue[0];
        }
        org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue[] values = new org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue[claimValues.length];
        for (int i = 0; i < claimValues.length; ++i) {
            org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue value = new org.wso2.carbon.user.mgt.stub.types.carbon.ClaimValue();
            value.setClaimURI(claimValues[i].getClaimURI());
            value.setValue(claimValues[i].getValue());
            values[i] = value;
        }
        return values;
    }

    public static org.wso2.carbon.user.mgt.common.UserStoreInfo toCommonUserStoreInfo(UserStoreInfo userStoreInfo) {
        org.wso2.carbon.user.mgt.common.UserStoreInfo usInfo = new org.wso2.carbon.user.mgt.common.UserStoreInfo();
        usInfo.setAdminRole(userStoreInfo.getAdminRole());
        usInfo.setAdminUser(userStoreInfo.getAdminUser());
        usInfo.setEveryOneRole(userStoreInfo.getEveryOneRole());
        usInfo.setReadOnly(userStoreInfo.getReadOnly());
        usInfo.setMaxUserListCount(userStoreInfo.getMaxUserListCount());
        usInfo.setJsRegEx(userStoreInfo.getJsRegEx());
        usInfo.setUserNameRegEx(userStoreInfo.getUserNameRegEx());
        usInfo.setRoleNameRegEx(userStoreInfo.getRoleNameRegEx());
        usInfo.setPasswordsExternallyManaged(userStoreInfo.getPasswordsExternallyManaged());
        usInfo.setBulkImportSupported(userStoreInfo.getBulkImportSupported());
        usInfo.setExternalIdP(userStoreInfo.getExternalIdP());
        return usInfo;
    }

    public static FlaggedName[] buildFalggedArray(String[] shownUsers, String[] selectedUsers) {
        Arrays.sort(selectedUsers);
        FlaggedName[] flaggedNames = new FlaggedName[shownUsers.length];
        for (int i = 0; i < shownUsers.length; ++i) {
            String name = shownUsers[i];
            FlaggedName flagName = new FlaggedName();
            flagName.setItemName(name);
            if (Arrays.binarySearch(selectedUsers, name) > -1) {
                flagName.setSelected(true);
            }
            flaggedNames[i] = flagName;
        }
        return flaggedNames;
    }

    public static UIPermissionNode toCommonUIPermissionNode(org.wso2.carbon.user.mgt.stub.types.carbon.UIPermissionNode parentNode) {
        UIPermissionNode uiPermissionNode = new UIPermissionNode();
        uiPermissionNode.setDisplayName(parentNode.getDisplayName());
        uiPermissionNode.setResourcePath(parentNode.getResourcePath());
        uiPermissionNode.setSelected(parentNode.getSelected());
        UIPermissionNode[] children = null;
        if (parentNode.getNodeList() != null) {
            children = new UIPermissionNode[parentNode.getNodeList().length];
            for (int i = 0; i < parentNode.getNodeList().length; ++i) {
                UIPermissionNode child;
                children[i] = child = Util.toCommonUIPermissionNode(parentNode.getNodeList()[i]);
            }
        } else {
            children = new UIPermissionNode[]{};
        }
        uiPermissionNode.setNodeList(children);
        return uiPermissionNode;
    }

    public static DataHandler buildDataHandler(byte[] content) {
        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
        return dataHandler;
    }

    public static PaginatedNamesBean retrivePaginatedFlggedName(int pageNumber, String[] names) {
        ArrayList<FlaggedName> list = new ArrayList<FlaggedName>();
        for (String name : names) {
            FlaggedName flaggedName = new FlaggedName();
            flaggedName.setItemName(name);
            list.add(flaggedName);
        }
        return Util.retrivePaginatedFlggedName(pageNumber, list.toArray(new FlaggedName[list.size()]));
    }

    public static PaginatedNamesBean retrivePaginatedFlggedName(int pageNumber, FlaggedName[] names) {
        PaginatedNamesBean bean = new PaginatedNamesBean();
        ArrayList<FlaggedName> list = new ArrayList<FlaggedName>();
        for (FlaggedName name : names) {
            list.add(name);
        }
        DataPaginator.doPaging((int)pageNumber, list, (Pageable)bean);
        return bean;
    }
}

