/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.api;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RealmConfiguration {
    protected String userStoreClass = null;
    protected String authorizationManagerClass = null;
    protected String adminRoleName = null;
    protected String adminUserName = null;
    protected String adminPassword = null;
    protected String everyOneRoleName = null;
    protected String realmClassName = null;
    protected Map<String, String> userStoreProperties = new HashMap<String, String>();
    protected Map<String, String> authzProperties = new HashMap<String, String>();
    protected Map<String, String> realmProperties = new HashMap<String, String>();
    protected int tenantId = -1234;
    protected Date persistedTimestamp;
    protected boolean passwordsExternallyManaged = false;

    public boolean isPasswordsExternallyManaged() {
        return this.passwordsExternallyManaged;
    }

    public void setPasswordsExternallyManaged(boolean passwordsExternallyManaged) {
        this.passwordsExternallyManaged = passwordsExternallyManaged;
    }

    public RealmConfiguration cloneRealmConfiguration() throws Exception {
        RealmConfiguration realmConfig = new RealmConfiguration();
        realmConfig.setRealmClassName(this.realmClassName);
        realmConfig.setUserStoreClass(this.userStoreClass);
        realmConfig.setAuthorizationManagerClass(this.authorizationManagerClass);
        realmConfig.setAdminRoleName(this.adminRoleName);
        realmConfig.setAdminUserName(this.adminUserName);
        realmConfig.setAdminPassword(this.adminPassword);
        realmConfig.setEveryOneRoleName(this.everyOneRoleName);
        HashMap<String, String> mapUserstore = new HashMap<String, String>();
        mapUserstore.putAll(this.userStoreProperties);
        realmConfig.setUserStoreProperties(mapUserstore);
        HashMap<String, String> mapAuthz = new HashMap<String, String>();
        mapAuthz.putAll(this.authzProperties);
        realmConfig.setAuthzProperties(mapAuthz);
        HashMap<String, String> mapRealm = new HashMap<String, String>();
        mapRealm.putAll(this.realmProperties);
        realmConfig.setRealmProperties(mapRealm);
        return realmConfig;
    }

    public void setRealmClassName(String realmClassName) {
        this.realmClassName = realmClassName;
    }

    public String getAuthorizationPropertyValue(String propertyName) {
        return this.authzProperties.get(propertyName);
    }

    public String getRealmProperty(String propertyName) {
        return this.realmProperties.get(propertyName);
    }

    public String getUserStoreProperty(String propertyName) {
        return this.userStoreProperties.get(propertyName);
    }

    public String getAdminRoleName() {
        return this.adminRoleName;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getEveryOneRoleName() {
        return this.everyOneRoleName;
    }

    public String getAuthorizationManagerClass() {
        return this.authorizationManagerClass;
    }

    public String getAuthorizationManagerProperty(String key) {
        return this.authzProperties.get(key);
    }

    public String getUserStoreClass() {
        return this.userStoreClass;
    }

    public Map<String, String> getUserStoreProperties() {
        return this.userStoreProperties;
    }

    public Map<String, String> getAuthzProperties() {
        return this.authzProperties;
    }

    public Map<String, String> getRealmProperties() {
        return this.realmProperties;
    }

    public void setAdminRoleName(String adminRoleName) {
        this.adminRoleName = adminRoleName;
    }

    public void setEveryOneRoleName(String everyOneRoleName) {
        this.everyOneRoleName = everyOneRoleName;
    }

    public void setAuthzProperties(Map<String, String> authzProperties) {
        this.authzProperties = authzProperties;
    }

    public void setRealmProperties(Map<String, String> realmProperties) {
        this.realmProperties = realmProperties;
    }

    public void setAuthorizationManagerClass(String authorizationManagerClass) {
        this.authorizationManagerClass = authorizationManagerClass;
    }

    public void setUserStoreClass(String userStoreClass) {
        this.userStoreClass = userStoreClass;
    }

    public void setUserStoreProperties(Map<String, String> userStoreProperties) {
        this.userStoreProperties = userStoreProperties;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public Date getPersistedTimestamp() {
        if (null != this.persistedTimestamp) {
            return (Date)this.persistedTimestamp.clone();
        }
        return null;
    }

    public void setPersistedTimestamp(Date persistedTimestamp) {
        this.persistedTimestamp = null != persistedTimestamp ? (Date)persistedTimestamp.clone() : null;
    }

    public String getRealmClassName() {
        if (this.realmClassName == null) {
            return "org.wso2.carbon.user.core.common.DefaultRealm";
        }
        return this.realmClassName;
    }
}

