/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.api;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.usage.beans.BandwidthStatistics;
import org.wso2.carbon.usage.beans.InstanceUsageStatics;
import org.wso2.carbon.usage.beans.RequestStatistics;
import org.wso2.carbon.usage.beans.TenantDataCapacity;
import org.wso2.carbon.usage.beans.TenantUsage;
import org.wso2.carbon.usage.meteringqueryds.stub.MeteringQueryDSStub;
import org.wso2.carbon.usage.meteringqueryds.stub.beans.xsd.BandwidthStat;
import org.wso2.carbon.usage.meteringqueryds.stub.beans.xsd.InstanceUsageStat;
import org.wso2.carbon.usage.meteringqueryds.stub.beans.xsd.RegBandwidthStat;
import org.wso2.carbon.usage.meteringqueryds.stub.beans.xsd.ServiceRequestStat;
import org.wso2.carbon.usage.util.Util;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantUsageRetriever {
    private static final Log log = LogFactory.getLog(TenantUsageRetriever.class);
    private static final String DEFAULT_SERVICE_NAME = "Stratos";
    private static final String METERING_ENDPOINT = "local://services/MeteringQueryDS";
    private static final String TOTAL_LABEL = "Total";
    public static final int REG_BANDWIDTH_INDEX = 0;
    public static final int SVC_BANDWIDTH_INDEX = 1;
    public static final int WEBAPP_BANDWIDTH_INDEX = 2;
    private RegistryService registryService;
    private MeteringQueryDSStub meteringStub;

    public TenantUsageRetriever(RegistryService registryService, ConfigurationContext configContext) throws Exception {
        this.registryService = registryService;
        if (configContext != null) {
            try {
                this.meteringStub = new MeteringQueryDSStub(configContext, METERING_ENDPOINT);
            }
            catch (AxisFault e) {
                String msg = "Error in creating BAM metering stub.";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        } else {
            String msg = "Unable to create TenantUsageRetriever";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    public TenantDataCapacity getDataCapacity(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        RegBandwidthStat[] stats = currentMonth ? this.meteringStub.getDailyRegistryBandwidthUsageStats(tenantId, startDate, endDate) : this.meteringStub.getRegistryBandwidthUsageStats(tenantId, startDate, endDate);
        TenantDataCapacity capacity = new TenantDataCapacity();
        if (stats != null && stats[0] != null) {
            capacity.setRegistryContentCapacity(stats[0].getRegistryBandwidth());
            capacity.setRegistryContentHistoryCapacity(stats[0].getRegistryHistoryBandwidth());
        }
        return capacity;
    }

    public int getCurrentUserCount(int tenantId) throws RegistryException {
        int usersCount;
        UserRealm userRealm = this.registryService.getUserRealm(tenantId);
        try {
            String[] users = userRealm.getUserStoreManager().listUsers("*", -1);
            usersCount = users.length;
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the current users.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return usersCount;
    }

    public BandwidthStatistics[][] getBandwidthStatistics(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        BandwidthStat[] stats = currentMonth ? this.meteringStub.getHourlyBandwidthStats(tenantId, startDate, endDate) : this.meteringStub.getBandwidthStats(tenantId, startDate, endDate);
        HashMap<String, BandwidthStatistics> regBwMap = new HashMap<String, BandwidthStatistics>();
        HashMap svcBwMap = new HashMap();
        HashMap webappBwMap = new HashMap();
        if (stats != null) {
            for (BandwidthStat stat : stats) {
                HashMap<String, BandwidthStatistics> bwMap;
                if (stat.getIncomingBandwidth() == 0L && stat.getOutgoingBandwidth() == 0L) continue;
                String serverName = this.extractServiceNameFromUrl(stat.getServerUrl());
                String bandwidthName = stat.getBandwidthName();
                if (bandwidthName.equals("RegistryBandwidth")) {
                    bwMap = regBwMap;
                } else if (bandwidthName.equals("ServiceBandwidth")) {
                    bwMap = svcBwMap;
                } else if (bandwidthName.equals("WebappBandwidth")) {
                    bwMap = webappBwMap;
                } else {
                    log.warn((Object)("Unable to identify bandwidth name " + bandwidthName));
                    continue;
                }
                BandwidthStatistics reqStat = (BandwidthStatistics)bwMap.get(serverName);
                if (reqStat == null) {
                    reqStat = new BandwidthStatistics(serverName);
                    bwMap.put(serverName, reqStat);
                }
                reqStat.setIncomingBandwidth(reqStat.getIncomingBandwidth() + stat.getIncomingBandwidth());
                reqStat.setOutgoingBandwidth(reqStat.getOutgoingBandwidth() + stat.getOutgoingBandwidth());
            }
        }
        BandwidthStatistics[][] returnValue = new BandwidthStatistics[3][];
        Collection values = regBwMap.values();
        returnValue[0] = values.toArray(new BandwidthStatistics[values.size()]);
        values = svcBwMap.values();
        returnValue[1] = values.toArray(new BandwidthStatistics[values.size()]);
        values = webappBwMap.values();
        returnValue[2] = values.toArray(new BandwidthStatistics[values.size()]);
        return returnValue;
    }

    public RequestStatistics[] getRequestStatistics(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        ServiceRequestStat[] stats = currentMonth ? this.meteringStub.getHourlyServiceRequestStats(tenantId, startDate, endDate) : this.meteringStub.getServiceRequestStats(tenantId, startDate, endDate);
        HashMap<String, RequestStatistics> tempReqStatMap = new HashMap<String, RequestStatistics>();
        if (stats != null) {
            for (ServiceRequestStat stat : stats) {
                if (stat.getReqCount() == 0L) continue;
                String serverName = this.extractServiceNameFromUrl(stat.getServerUrl());
                RequestStatistics reqStat = (RequestStatistics)tempReqStatMap.get(serverName);
                if (reqStat == null) {
                    reqStat = new RequestStatistics(serverName);
                    tempReqStatMap.put(serverName, reqStat);
                }
                reqStat.setRequestCount(reqStat.getRequestCount() + stat.getReqCount());
                reqStat.setResponseCount(reqStat.getResponseCount() + stat.getResCount());
                reqStat.setFaultCount(reqStat.getFaultCount() + stat.getFaultCount());
            }
        }
        Collection values = tempReqStatMap.values();
        return values.toArray(new RequestStatistics[values.size()]);
    }

    public TenantUsage getTenantUsage(int tenantId, String yearMonth) throws Exception {
        TenantDataCapacity capacity;
        TenantManager tenantManger = Util.getRealmService().getTenantManager();
        String domain = tenantManger.getDomain(tenantId);
        TenantUsage tenantUsage = new TenantUsage(tenantId, domain);
        Date date = CommonUtil.getDateFromMonthString((String)yearMonth);
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(date);
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(2, 1);
        boolean isCurrentMonth = Calendar.getInstance().compareTo(endDate) <= 0;
        try {
            capacity = this.getDataCapacity(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting data capacity from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setRegistryCapacity(capacity);
        RequestStatistics[] reqStats = null;
        try {
            reqStats = this.getRequestStatistics(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting request statistics from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setRequestStatistics(reqStats);
        RequestStatistics totalReqStat = new RequestStatistics(TOTAL_LABEL);
        long totalReq = 0L;
        long totalRes = 0L;
        long totalFault = 0L;
        for (RequestStatistics stat : reqStats) {
            totalReq += stat.getRequestCount();
            totalRes += stat.getResponseCount();
            totalFault += stat.getFaultCount();
        }
        totalReqStat.setRequestCount(totalReq);
        totalReqStat.setResponseCount(totalRes);
        totalReqStat.setFaultCount(totalFault);
        tenantUsage.setTotalRequestStatistics(totalReqStat);
        BandwidthStatistics[][] bwStats = null;
        try {
            bwStats = this.getBandwidthStatistics(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting bandwidth statistics from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setRegistryBandwidthStatistics(bwStats[0]);
        tenantUsage.setServiceBandwidthStatistics(bwStats[1]);
        tenantUsage.setWebappBandwidthStatistics(bwStats[2]);
        int index = 0;
        for (BandwidthStatistics[] bwArray : bwStats) {
            long incomingBandwidth = 0L;
            long outgoingBandwidth = 0L;
            for (BandwidthStatistics bandwidth : bwArray) {
                incomingBandwidth += bandwidth.getIncomingBandwidth();
                outgoingBandwidth += bandwidth.getOutgoingBandwidth();
            }
            BandwidthStatistics total = new BandwidthStatistics(TOTAL_LABEL);
            total.setIncomingBandwidth(incomingBandwidth);
            total.setOutgoingBandwidth(outgoingBandwidth);
            switch (index) {
                case 0: {
                    tenantUsage.setTotalRegistryBandwidth(total);
                    break;
                }
                case 1: {
                    tenantUsage.setTotalServiceBandwidth(total);
                    break;
                }
                case 2: {
                    tenantUsage.setTotalWebappBandwidth(total);
                }
            }
            ++index;
        }
        if (isCurrentMonth) {
            int usersCount = this.getCurrentUserCount(tenantId);
            tenantUsage.setNumberOfUsers(usersCount);
        }
        return tenantUsage;
    }

    private String extractServiceNameFromUrl(String serviceURL) {
        if (serviceURL == null || serviceURL.equals("")) {
            return DEFAULT_SERVICE_NAME;
        }
        int startIndex = serviceURL.indexOf("://");
        startIndex = startIndex != -1 ? (startIndex += 3) : 0;
        int endIndex = serviceURL.indexOf(46, startIndex);
        if (endIndex == -1 && (endIndex = serviceURL.indexOf(58, startIndex)) == -1 && (endIndex = serviceURL.indexOf(47, startIndex)) == -1) {
            endIndex = serviceURL.length();
        }
        return serviceURL.substring(startIndex, endIndex);
    }

    public InstanceUsageStatics[] getInstanceUsages() throws Exception {
        InstanceUsageStat[] instanceData = this.meteringStub.getInstanceUsageStats();
        if (instanceData == null || instanceData.length == 0) {
            return null;
        }
        InstanceUsageStatics[] returnValue = new InstanceUsageStatics[instanceData.length];
        int elementID = 0;
        for (InstanceUsageStat iu : instanceData) {
            InstanceUsageStatics iu1 = new InstanceUsageStatics();
            iu1.setInstanceID(iu.getInstanceId().intValue());
            iu1.setInstanceURL(iu.getServerURL());
            iu1.setStartTime(iu.getStartTimestamp());
            iu1.setStopTime(iu.getStopTimestamp());
            iu1.setRunning(iu.getIsRunning());
            returnValue[elementID] = iu1;
            ++elementID;
        }
        return returnValue;
    }
}

