/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.services;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.usage.beans.InstanceUsageStatics;
import org.wso2.carbon.usage.beans.PaginatedInstanceUsage;
import org.wso2.carbon.usage.beans.PaginatedTenantUsageInfo;
import org.wso2.carbon.usage.beans.TenantUsage;
import org.wso2.carbon.usage.util.Util;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class UsageService
extends AbstractAdmin {
    public TenantUsage retrieveCurrentTenantUsage(String yearMonth) throws Exception {
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        int tenantId = registry.getTenantId();
        return Util.getTenantUsageRetriever().getTenantUsage(tenantId, yearMonth);
    }

    public TenantUsage[] retrieveTenantUsages(String yearMonth) throws Exception {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        Tenant[] tenants = (Tenant[])tenantManager.getAllTenants();
        ArrayList<TenantUsage> tenantUsages = new ArrayList<TenantUsage>();
        for (Tenant tenant : tenants) {
            if (!tenant.isActive()) continue;
            TenantUsage tenantUsage = Util.getTenantUsageRetriever().getTenantUsage(tenant.getId(), yearMonth);
            tenantUsages.add(tenantUsage);
        }
        return tenantUsages.toArray(new TenantUsage[tenantUsages.size()]);
    }

    public PaginatedTenantUsageInfo retrievePaginatedTenantUsages(String yearMonth, int pageNumber, int entriesPerPage) throws Exception {
        TenantManager tenantManager = Util.getRealmService().getTenantManager();
        Tenant[] tenants = (Tenant[])tenantManager.getAllTenants();
        ArrayList<TenantUsage> tenantUsages = new ArrayList<TenantUsage>();
        int i = 0;
        int numberOfPages = 0;
        for (Tenant tenant : tenants) {
            if (!tenant.isActive()) continue;
            if (i % entriesPerPage == 0) {
                ++numberOfPages;
            }
            if (numberOfPages == pageNumber) {
                TenantUsage tenantUsage = Util.getTenantUsageRetriever().getTenantUsage(tenant.getId(), yearMonth);
                tenantUsages.add(tenantUsage);
            }
            ++i;
        }
        PaginatedTenantUsageInfo paginatedTenantInfo = new PaginatedTenantUsageInfo();
        paginatedTenantInfo.setTenantUsages(tenantUsages.toArray(new TenantUsage[tenantUsages.size()]));
        paginatedTenantInfo.setNumberOfPages(numberOfPages);
        paginatedTenantInfo.setPageNumber(pageNumber);
        return paginatedTenantInfo;
    }

    public TenantUsage retrieveTenantUsage(String yearMonth, int tenantId) throws Exception {
        return Util.getTenantUsageRetriever().getTenantUsage(tenantId, yearMonth);
    }

    public InstanceUsageStatics[] retrieveInstanceUsage() throws Exception {
        return Util.getTenantUsageRetriever().getInstanceUsages();
    }

    public PaginatedInstanceUsage retrievePaginatedInstanceUsage(String yearMonth, int pageNumber, int entriesPerPage) throws Exception {
        InstanceUsageStatics[] instanceUsages = this.retrieveInstanceUsage();
        ArrayList instanceUsagesList = new ArrayList();
        PaginatedInstanceUsage paginatedInstanceUsages = new PaginatedInstanceUsage();
        int i = 0;
        int numberOfPages = 0;
        if (instanceUsages != null && instanceUsages.length > 0) {
            for (InstanceUsageStatics usage : instanceUsages) {
                InstanceUsageStatics instance = this.getValidUsageEntry(usage, yearMonth);
                if (instance == null || i % entriesPerPage != 0) continue;
                ++numberOfPages;
            }
            paginatedInstanceUsages.setInstanceUsages(instanceUsagesList.toArray(new InstanceUsageStatics[instanceUsagesList.size()]));
        } else {
            paginatedInstanceUsages.setInstanceUsages(null);
        }
        paginatedInstanceUsages.setNumberOfPages(numberOfPages);
        paginatedInstanceUsages.setPageNumber(pageNumber);
        return paginatedInstanceUsages;
    }

    public InstanceUsageStatics getValidUsageEntry(InstanceUsageStatics usage, String yearMonth) {
        Date date = Calendar.getInstance().getTime();
        if (yearMonth != null) {
            try {
                date = CommonUtil.getDateFromMonthString((String)yearMonth);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(date);
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(2, 1);
        if (usage.getStartTime().compareTo(startDate) <= 0 && usage.getStopTime().compareTo(endDate) >= 0) {
            usage.setUsedTimeInSeconds((endDate.getTimeInMillis() - startDate.getTimeInMillis()) / 1000L);
            return usage;
        }
        if (usage.getStartTime().compareTo(startDate) > 0 && usage.getStartTime().compareTo(endDate) < 0) {
            if (usage.getStopTime().compareTo(endDate) < 0) {
                usage.setUsedTimeInSeconds((usage.getStopTime().getTimeInMillis() - usage.getStartTime().getTimeInMillis()) / 1000L);
                return usage;
            }
            if (usage.getStopTime().compareTo(endDate) > 0) {
                usage.setUsedTimeInSeconds((endDate.getTimeInMillis() - usage.getStartTime().getTimeInMillis()) / 1000L);
                return usage;
            }
        }
        if (usage.getStartTime().compareTo(startDate) < 0 && usage.getStopTime().compareTo(endDate) < 0 && usage.getStopTime().compareTo(startDate) > 0) {
            usage.setUsedTimeInSeconds((usage.getStopTime().getTimeInMillis() - startDate.getTimeInMillis()) / 1000L);
            return usage;
        }
        return null;
    }
}

