/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.summary.generator.client;

import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.usage.meteringsummarygenerationds.stub.MeteringSummaryGenerationDSStub;
import org.wso2.carbon.usage.meteringsummarygenerationds.stub.beans.xsd.SummaryTime;

public class UsageSummaryGeneratorClient {
    private MeteringSummaryGenerationDSStub meteringStub;
    private static final String METERING_ENDPOINT = "local://services/MeteringSummaryGenerationDS";
    private static final Log log = LogFactory.getLog(UsageSummaryGeneratorClient.class);

    public UsageSummaryGeneratorClient(ConfigurationContext configContext) throws Exception {
        if (configContext != null) {
            try {
                this.meteringStub = new MeteringSummaryGenerationDSStub(configContext, METERING_ENDPOINT);
            }
            catch (AxisFault e) {
                String msg = "Error in creating BAM metering stub.";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        } else {
            String msg = "Unable to create UsageSummaryGeneratorClient";
            log.error((Object)msg);
            throw new Exception(msg);
        }
    }

    public MeteringSummaryGenerationDSStub getStub() {
        return this.meteringStub;
    }

    public Calendar getLatestSummaryTime(int summaryPeriod, int serverId) throws BAMException {
        BAMCalendar cal = null;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.meteringStub.getLatestHourlyBandwidthSummaryPeriodId(serverId);
                    break;
                }
                case 5: {
                    time = this.meteringStub.getLatestDailyBandwidthSummaryPeriodId(serverId);
                    break;
                }
                case 2: {
                    time = this.meteringStub.getLatestMonthlyBandwidthSummaryPeriodId(serverId);
                    break;
                }
                case 50: {
                    time = this.meteringStub.getLatestQuarterlyBandwidthSummaryPeriodId(serverId);
                    break;
                }
                case 1: {
                    time = this.meteringStub.getLatestYearlyBandwidthSummaryPeriodId(serverId);
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            if (time != null && time[0] != null) {
                cal = BAMCalendar.getInstance((Calendar)time[0].getStartTime());
            } else {
                time = this.meteringStub.getMinimumPeriodId(serverId);
                cal = time != null && time[0] != null ? BAMCalendar.getInstance((Calendar)time[0].getStartTime()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    public Calendar getLatestRegSummaryTime(int summaryPeriod, int tenantId) throws BAMException {
        BAMCalendar cal = null;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 5: {
                    time = this.meteringStub.getLatestDailyRegistryBandwidthSummaryPeriodId(tenantId);
                    break;
                }
                case 2: {
                    time = this.meteringStub.getLatestMonthlyRegistryBandwidthSummaryPeriodId(tenantId);
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            if (time == null || time[0] == null) {
                cal = BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            } else {
                cal = BAMCalendar.getInstance((Calendar)time[0].getStartTime());
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }
}

