/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.summary.generator;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.usage.summary.generator.RegistryUsageSummaryGenerator;
import org.wso2.carbon.usage.summary.generator.client.UsageSummaryGeneratorClient;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class RegistryUsageSummaryGeneratorTask
extends TimerTask {
    private UsageSummaryGeneratorClient client;
    private RealmService realmService;
    private static final Log log = LogFactory.getLog(RegistryUsageSummaryGeneratorTask.class);

    public RegistryUsageSummaryGeneratorTask(UsageSummaryGeneratorClient client, RealmService realmService) {
        this.client = client;
        this.realmService = realmService;
    }

    public void run() {
        TenantManager tenantManager = this.realmService.getTenantManager();
        try {
            Tenant[] tenants;
            for (Tenant tenant : tenants = (Tenant[])tenantManager.getAllTenants()) {
                String msg;
                RegistryUsageSummaryGenerator generator = new RegistryUsageSummaryGenerator(tenant, 5, this.client);
                try {
                    generator.generateSummary();
                }
                catch (BAMException e) {
                    msg = "Unable to generate Daily Registry Usage Summary for tenant " + tenant.getDomain();
                    log.error((Object)msg, (Throwable)e);
                }
                generator = new RegistryUsageSummaryGenerator(tenant, 2, this.client);
                try {
                    generator.generateSummary();
                }
                catch (BAMException e) {
                    msg = "Unable to generate Monthly Registry Usage Summary for tenant " + tenant.getDomain();
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
        catch (UserStoreException e) {
            String msg = "Unable to get tenants from realmService. Failed to generate Registry Usage Summary";
            log.error((Object)msg, (Throwable)e);
        }
    }
}

