/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.summary.generator;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.usage.meteringsummarygenerationds.stub.beans.xsd.BandwidthUsage;
import org.wso2.carbon.usage.meteringsummarygenerationds.stub.beans.xsd.BandwidthUsageValue;
import org.wso2.carbon.usage.summary.generator.client.UsageSummaryGeneratorClient;
import org.wso2.carbon.user.core.tenant.Tenant;

public class RegistryUsageSummaryGenerator
extends AbstractSummaryGenerator {
    UsageSummaryGeneratorClient client;
    Tenant tenant;
    private static final Log log = LogFactory.getLog(RegistryUsageSummaryGenerator.class);

    public RegistryUsageSummaryGenerator(Tenant tenant, int timeInterval, UsageSummaryGeneratorClient client) {
        super(timeInterval);
        this.client = client;
        this.tenant = tenant;
    }

    protected Calendar getLatestDailySummaryTime() throws BAMException {
        return this.client.getLatestRegSummaryTime(this.getTimeInterval(), this.tenant.getId());
    }

    protected void summarizeDaily(BAMCalendar start, BAMCalendar end) {
        long regBandwidth = 0L;
        long regHistoryBandwidth = 0L;
        try {
            BandwidthUsage[] usages;
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            DayDimension dd = spm.getDayDimension((Calendar)start);
            if (dd == null) {
                spm.addDayDimension(start);
                dd = spm.getDayDimension((Calendar)start);
            }
            if ((usages = this.client.getStub().getRegistryBandwidthUsage(this.tenant.getId())) != null && usages[0] != null && (regBandwidth = usages[0].getBandwidth()) < 0L) {
                regBandwidth = 0L;
            }
            if ((usages = this.client.getStub().getRegistryHistoryBandwidthUsage(this.tenant.getId())) != null && usages[0] != null && (regHistoryBandwidth = usages[0].getBandwidth()) < 0L) {
                regHistoryBandwidth = 0L;
            }
            this.client.getStub().addRegistryBandwidthUsageDailySummary(this.tenant.getId(), dd.getId(), "ContentBandwidth", regBandwidth, regHistoryBandwidth);
        }
        catch (Exception e) {
            String msg = "Unable to run Registry Usage daily summary for domain " + this.tenant.getDomain();
            log.error((Object)msg, (Throwable)e);
        }
    }

    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        return this.client.getLatestRegSummaryTime(this.getTimeInterval(), this.tenant.getId());
    }

    protected void summarizeMonthly(BAMCalendar start, BAMCalendar end) {
        long regBandwidth = 0L;
        long regHistoryBandwidth = 0L;
        try {
            BandwidthUsageValue[] usages;
            SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
            MonthDimension md = spm.getMonthDimension((Calendar)start);
            if (md == null) {
                spm.addMonthDimension(start);
                md = spm.getMonthDimension((Calendar)start);
            }
            if ((usages = this.client.getStub().getRegistryBandwidthUsageForMonthlySummary(this.tenant.getId(), (Calendar)start, (Calendar)end)) != null && usages[0] != null) {
                regBandwidth = usages[0].getRegistryBandwidth();
                regHistoryBandwidth = usages[0].getRegistryHistoryBandwidth();
                if (regBandwidth < 0L) {
                    regBandwidth = 0L;
                }
                if (regHistoryBandwidth < 0L) {
                    regHistoryBandwidth = 0L;
                }
            }
            this.client.getStub().addRegistryBandwidthUsageMonthlySummary(this.tenant.getId(), md.getId(), "ContentBandwidth", regBandwidth, regHistoryBandwidth);
        }
        catch (Exception e) {
            String msg = "Unable to run Registry Usage monthly summary for domain " + this.tenant.getDomain();
            log.error((Object)msg, (Throwable)e);
        }
    }

    protected void summarizeHourly(BAMCalendar loHour, BAMCalendar hiHour) {
    }

    protected void summarizeQuarterly(BAMCalendar loQuarter, BAMCalendar hiQuarter) {
    }

    protected void summarizeYearly(BAMCalendar loYear, BAMCalendar hiYear) {
    }

    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        return null;
    }

    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        return null;
    }

    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        return null;
    }

    protected String getInstanceInfo() {
        return "Tenant: " + this.tenant.getDomain();
    }
}

