/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.internal;

import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.usage.agent.util.PublisherUtils;
import org.wso2.carbon.usage.agent.util.Util;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class UsageAgentServiceComponent {
    private static Log log = LogFactory.getLog(UsageAgentServiceComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
            SuperTenantCarbonContext.getCurrentContext().setUsername("wso2.system.user");
            SuperTenantCarbonContext.getCurrentContext().setUserRealm((UserRealm)Util.getRealmService().getBootstrapRealm());
            Util.initializeAllListeners();
            Util.initializePersistenceManager();
            Util.createStaticEventSubscription();
            log.debug((Object)"******* Multitenancy Usage Agent bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Multitenancy Usage Agent bundle ****", e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Metering Usage Agent bundle is deactivated ******* ");
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        Util.setConfigurationContextService(contextService);
        PublisherUtils.setConfigurationContextService(contextService);
        try {
            contextService.getServerConfigContext().getAxisConfiguration().engageModule("metering");
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to engage request metering Module", (Throwable)e);
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        try {
            AxisConfiguration axisConfig = contextService.getServerConfigContext().getAxisConfiguration();
            axisConfig.disengageModule(axisConfig.getModule("metering"));
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to disengage request metering Module", (Throwable)e);
        }
        Util.setConfigurationContextService(null);
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        Util.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        Util.setServerConfiguration(null);
    }

    protected void setEventBrokerService(EventBroker registryEventBrokerService) {
        Util.setEventBrokerService(registryEventBrokerService);
    }

    protected void unsetEventBrokerService(EventBroker registryEventBrokerService) {
        Util.setEventBrokerService(null);
    }
}

