/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.config.UsageAgentConfiguration;
import org.wso2.carbon.usage.agent.listeners.RegistryUsageListener;
import org.wso2.carbon.usage.agent.persist.UsageDataPersistenceManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static final String USAGE_THROTTLING_AGENT_CONFIG_FILE = "usage-throttling-agent-config.xml";
    private static RealmService realmService;
    private static ConfigurationContextService contextService;
    private static UsageDataPersistenceManager persistenceManager;
    private static EventBroker eventBrokerService;
    private static ServerConfigurationService serverConfiguration;

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static void initializeAllListeners() throws Exception {
        RegistryUsageListener.registerRegistryUsagePersistingListener(RegistryContext.getBaseInstance());
    }

    public static void setConfigurationContextService(ConfigurationContextService contextService) {
        Util.contextService = contextService;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return contextService;
    }

    public static void initializePersistenceManager() {
        File usageAgentConfigFile = new File(CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + USAGE_THROTTLING_AGENT_CONFIG_FILE);
        persistenceManager = new UsageDataPersistenceManager(new UsageAgentConfiguration(usageAgentConfigFile));
        persistenceManager.scheduleBandwidthUsageDataRetrievalTask();
        persistenceManager.scheduleUsageDataPersistenceTask();
    }

    public static void addToPersistingControllerQueue(BandwidthUsage usage) {
        persistenceManager.addToQueue(usage);
    }

    public static EventBroker getEventBrokerService() {
        return eventBrokerService;
    }

    public static void setEventBrokerService(EventBroker eventBrokerService) {
        Util.eventBrokerService = eventBrokerService;
    }

    public static ServerConfigurationService getServerConfiguration() {
        return serverConfiguration;
    }

    public static void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        Util.serverConfiguration = serverConfiguration;
    }

    public static void createStaticEventSubscription() throws EventBrokerException {
        ServerConfigurationService serverConfiguration = Util.getServerConfiguration();
        if (serverConfiguration == null) {
            throw new IllegalArgumentException("Invalid server configuration");
        }
        String serverURL = serverConfiguration.getFirstProperty("BamServerURL");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Bam url = " + serverURL));
        }
        if (serverURL != null) {
            String serviceURL = serverURL + "BAMServerUserDefinedDataSubscriberService";
            EventBroker eventBrokerService = Util.getEventBrokerService();
            Subscription subscription = new Subscription();
            subscription.setEventSinkURL(serviceURL);
            subscription.setTopicName("carbon/bam/data/publishers/bandwidth-stat");
            subscription.setOwner("wso2.system.user");
            subscription.setEventDispatcherName("wsEventDispatcher");
            try {
                eventBrokerService.subscribe(subscription);
            }
            catch (EventBrokerException e) {
                String msg = "Cannot subscribe to the event broker ";
                log.error((Object)msg);
                throw e;
            }
        }
    }
}

