/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UsageAgentConfiguration {
    private static final Log log = LogFactory.getLog(UsageAgentConfiguration.class);
    private static final Integer DEFAULT_NUMBER_OF_RECORDS_PER_RUN = 100;
    private static final Integer DEFAULT_EXECUTION_INTERVAL_IN_MILLISECONDS = 100;
    private static final Integer DEFAULT_STARTUP_DELAY_IN_MILLISECONDS = 60000;
    private int usageTasksNumberOfRecordsPerExecution;
    private int usageTasksExecutionIntervalInMilliSeconds;
    private int usageTasksStartupDelayInMilliSeconds;

    public UsageAgentConfiguration(File configFile) {
        block13: {
            this.usageTasksNumberOfRecordsPerExecution = -1;
            this.usageTasksExecutionIntervalInMilliSeconds = -1;
            this.usageTasksStartupDelayInMilliSeconds = -1;
            if (configFile.exists()) {
                try {
                    OMElement startupDelayInMilliSeconds;
                    OMElement executionIntervalInMilliSeconds;
                    OMElement usageDataPersistenceTaskConfig;
                    OMElement usageAgent;
                    OMElement usageAndThrottlingAgentConfiguration = new StAXOMBuilder((InputStream)new FileInputStream(configFile)).getDocumentElement();
                    if (usageAndThrottlingAgentConfiguration == null || (usageAgent = usageAndThrottlingAgentConfiguration.getFirstChildWithName(new QName("http://wso2.com/carbon/multitenancy/usage-throttling-agent/config", "UsageAgent"))) == null || (usageDataPersistenceTaskConfig = usageAgent.getFirstChildWithName(new QName("http://wso2.com/carbon/multitenancy/usage-throttling-agent/config", "UsageDataPersistenceTask"))) == null) break block13;
                    OMElement numberOfRecordsPerExecutionEle = usageDataPersistenceTaskConfig.getFirstChildWithName(new QName("http://wso2.com/carbon/multitenancy/usage-throttling-agent/config", "NumberOfRecordsPerExecution"));
                    if (numberOfRecordsPerExecutionEle != null && numberOfRecordsPerExecutionEle.getText() != null && numberOfRecordsPerExecutionEle.getText().length() > 0) {
                        try {
                            this.usageTasksNumberOfRecordsPerExecution = Integer.parseInt(numberOfRecordsPerExecutionEle.getText());
                        }
                        catch (NumberFormatException ne) {
                            log.error((Object)"Error while parsing usage persistence task number of records value.", (Throwable)ne);
                        }
                    }
                    if ((executionIntervalInMilliSeconds = usageDataPersistenceTaskConfig.getFirstChildWithName(new QName("http://wso2.com/carbon/multitenancy/usage-throttling-agent/config", "ExecutionIntervalInMilliSeconds"))) != null && executionIntervalInMilliSeconds.getText() != null && executionIntervalInMilliSeconds.getText().length() > 0) {
                        try {
                            this.usageTasksExecutionIntervalInMilliSeconds = Integer.parseInt(executionIntervalInMilliSeconds.getText());
                        }
                        catch (NumberFormatException ne) {
                            log.error((Object)"Error while parsing usage persistence task  execution interval value.", (Throwable)ne);
                        }
                    }
                    if ((startupDelayInMilliSeconds = usageDataPersistenceTaskConfig.getFirstChildWithName(new QName("http://wso2.com/carbon/multitenancy/usage-throttling-agent/config", "StartupDelayInMilliSeconds"))) != null && startupDelayInMilliSeconds.getText() != null && startupDelayInMilliSeconds.getText().length() > 0) {
                        try {
                            this.usageTasksStartupDelayInMilliSeconds = Integer.parseInt(startupDelayInMilliSeconds.getText());
                        }
                        catch (NumberFormatException ne) {
                            log.error((Object)"Error while parsing usage persistence task startup delay value.", (Throwable)ne);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Cannot find " + configFile.getAbsolutePath()), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    log.error((Object)("Error reading XML stream of file " + configFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    public int getUsageTasksNumberOfRecordsPerExecution() {
        if (this.usageTasksNumberOfRecordsPerExecution < 0) {
            return DEFAULT_NUMBER_OF_RECORDS_PER_RUN;
        }
        return this.usageTasksNumberOfRecordsPerExecution;
    }

    public int getUsageTasksExecutionIntervalInMilliSeconds() {
        if (this.usageTasksExecutionIntervalInMilliSeconds < 0) {
            return DEFAULT_EXECUTION_INTERVAL_IN_MILLISECONDS;
        }
        return this.usageTasksExecutionIntervalInMilliSeconds;
    }

    public int getUsageTasksStartupDelayInMilliSeconds() {
        if (this.usageTasksStartupDelayInMilliSeconds < 0) {
            return DEFAULT_STARTUP_DELAY_IN_MILLISECONDS;
        }
        return this.usageTasksStartupDelayInMilliSeconds;
    }
}

