/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.internal;

import java.util.List;
import org.apache.catalina.Host;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.url.mapper.HotUpdateService;
import org.wso2.carbon.url.mapper.internal.exception.UrlMapperException;
import org.wso2.carbon.url.mapper.internal.util.HostUtil;

public class HotUpdateManager
implements HotUpdateService {
    private static final Log log = LogFactory.getLog(HotUpdateManager.class);

    @Override
    public List<String> getMappigsPerWebapp(String webAppName) {
        try {
            return HostUtil.getMappingsPerWebApp(webAppName);
        }
        catch (UrlMapperException e) {
            log.error((Object)"error while retrieving from registry", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteHost(String hostName) {
        try {
            HostUtil.deleteResourceToRegistry(hostName);
        }
        catch (UrlMapperException e) {
            log.error((Object)("error while deleting host for " + hostName), (Throwable)e);
        }
    }

    @Override
    public Host addHost(String hostName) {
        return HostUtil.addHostToEngine(hostName);
    }

    @Override
    public String getWebappForHost(String hostName) {
        try {
            return HostUtil.getWebappForHost(hostName);
        }
        catch (UrlMapperException e) {
            log.error((Object)"error while getting webapp for host", (Throwable)e);
            return null;
        }
    }

    @Override
    public void removeHost(String hostName) {
        try {
            HostUtil.removeHost(hostName);
        }
        catch (UrlMapperException e) {
            log.error((Object)("error while removing host for " + hostName), (Throwable)e);
        }
    }
}

