/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.internal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;
import org.wso2.carbon.url.mapper.HotUpdateService;
import org.wso2.carbon.url.mapper.UrlMapperValve;
import org.wso2.carbon.url.mapper.internal.HotUpdateManager;
import org.wso2.carbon.url.mapper.internal.util.DataHolder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;

public class UrlMapperServiceComponent {
    private static Log log = LogFactory.getLog(UrlMapperServiceComponent.class);
    private ServiceRegistration serviceRegistration;

    protected void activate(ComponentContext componentContext) {
        final BundleContext bundleContext = componentContext.getBundleContext();
        if (!CarbonUtils.isRunningInStandaloneMode()) {
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        bundleContext.getBundle().uninstall();
                    }
                    catch (Throwable e) {
                        log.warn((Object)"Error occurred while uninstalling webapp-mgt UI bundle", e);
                    }
                }
            };
            try {
                th.join();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            th.start();
        }
        this.serviceRegistration = bundleContext.registerService(HotUpdateService.class.getName(), (Object)new HotUpdateManager(), null);
        ArrayList<UrlMapperValve> carbonTomcatValves = new ArrayList<UrlMapperValve>();
        carbonTomcatValves.add(new UrlMapperValve());
        TomcatValveContainer.addValves(carbonTomcatValves);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.serviceRegistration.unregister();
    }

    protected void setCarbonTomcatService(CarbonTomcatService carbonTomcatService) {
        DataHolder.getInstance().setCarbonTomcatService(carbonTomcatService);
    }

    protected void unsetCarbonTomcatService(CarbonTomcatService carbonTomcatService) {
        DataHolder.getInstance().setCarbonTomcatService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            DataHolder.getInstance().setRegistry((Registry)registryService.getGovernanceSystemRegistry());
        }
        catch (Exception e) {
            log.error((Object)"Cannot  retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        DataHolder.getInstance().setRegistry(null);
    }

    protected void setRealmService(RealmService realmService) {
        DataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        DataHolder.getInstance().setRealmService(null);
    }
}

