/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.context.ApplicationContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;
import org.wso2.carbon.url.mapper.HotUpdateService;
import org.wso2.carbon.url.mapper.UrlMapperValve;
import org.wso2.carbon.url.mapper.data.MappingData;
import org.wso2.carbon.url.mapper.internal.HotUpdateManager;
import org.wso2.carbon.url.mapper.internal.exception.UrlMapperException;
import org.wso2.carbon.url.mapper.internal.util.DataHolder;
import org.wso2.carbon.url.mapper.internal.util.HostUtil;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;

public class UrlMapperServiceComponent {
    private static Log log = LogFactory.getLog(UrlMapperServiceComponent.class);
    private ServiceRegistration serviceRegistration;

    protected void activate(ComponentContext componentContext) {
        final BundleContext bundleContext = componentContext.getBundleContext();
        if (!CarbonUtils.isRunningInStandaloneMode()) {
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        bundleContext.getBundle().uninstall();
                    }
                    catch (Throwable e) {
                        log.warn((Object)"Error occurred while uninstalling webapp-mgt UI bundle", e);
                    }
                }
            };
            try {
                th.join();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            th.start();
        }
        this.serviceRegistration = bundleContext.registerService(HotUpdateService.class.getName(), (Object)new HotUpdateManager(), null);
        ArrayList<UrlMapperValve> carbonTomcatValves = new ArrayList<UrlMapperValve>();
        carbonTomcatValves.add(new UrlMapperValve());
        TomcatValveContainer.addValves(carbonTomcatValves);
        try {
            this.addHostToTomcat();
            this.addMappingToApplicationContext();
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while activating the UrlMapperServiceComponent", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        try {
            this.removeHostFromTomcat();
        }
        catch (UrlMapperException e) {
            log.error((Object)"error while unloading the hosts from engine ", (Throwable)e);
        }
        this.serviceRegistration.unregister();
    }

    protected void setCarbonTomcatService(CarbonTomcatService carbonTomcatService) {
        DataHolder.getInstance().setCarbonTomcatService(carbonTomcatService);
    }

    protected void unsetCarbonTomcatService(CarbonTomcatService carbonTomcatService) {
        DataHolder.getInstance().setCarbonTomcatService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            DataHolder.getInstance().setRegistry((Registry)registryService.getGovernanceSystemRegistry());
        }
        catch (Exception e) {
            log.error((Object)"Cannot  retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        DataHolder.getInstance().setRegistry(null);
    }

    protected void setRealmService(RealmService realmService) {
        DataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        DataHolder.getInstance().setRealmService(null);
    }

    public void addHostToTomcat() throws Exception {
        List<String> hosts = HostUtil.getAllHostsFromRegistry();
        if (hosts != null) {
            for (String hostName : hosts) {
                int tenantId = HostUtil.getTenantIdForHost(hostName);
                String appBase = tenantId == -1234 ? CarbonUtils.getCarbonRepository() + "webapps" + "/" : CarbonUtils.getCarbonTenantsDirPath() + "/" + tenantId + "/" + "webapps" + "/";
                HostUtil.addHostToEngine(hostName, appBase);
            }
        }
    }

    public void addMappingToApplicationContext() {
        MappingData[] urlmappings = new MappingData[]{};
        try {
            urlmappings = HostUtil.getAllMappingsFromRegistry();
        }
        catch (UrlMapperException e) {
            log.error((Object)"error while getting all mappings from registry");
        }
        for (MappingData mapping : urlmappings) {
            ApplicationContext.getCurrentApplicationContext().putUrlMappingForApplication(mapping.getMappingName(), mapping.getUrl());
        }
    }

    public void removeHostFromTomcat() throws UrlMapperException {
        List<String> hostNames = HostUtil.getAllHostsFromRegistry();
        CarbonTomcatService carbonTomcatService = DataHolder.getInstance().getCarbonTomcatService();
        Engine engine = carbonTomcatService.getTomcat().getEngine();
        Host host = null;
        for (String hostName : hostNames) {
            try {
                hostName = hostName.substring("/hostinfo/".length());
                host = (Host)engine.findChild(hostName);
                Context context = (Context)host.findChild("/");
                if (!host.getState().isAvailable()) continue;
                if (context.getAvailable()) {
                    context.setRealm(null);
                    context.stop();
                    context.destroy();
                    log.info((Object)("Unloaded webapp from the host: " + host + " as the context of: " + context));
                }
                host.removeChild((Container)context);
                host.setRealm(null);
                host.stop();
                host.destroy();
                engine.removeChild((Container)host);
                log.info((Object)("Unloaded host from the engine: " + host));
                HostUtil.deleteHostDirectory(hostName);
            }
            catch (LifecycleException e) {
                throw new UrlMapperException("Error when removing host from tomcat engine." + host, e);
            }
        }
    }
}

