/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.internal;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.url.mapper.HotUpdateService;
import org.wso2.carbon.url.mapper.internal.exception.UrlMapperException;
import org.wso2.carbon.url.mapper.internal.util.HostUtil;

public class HotUpdateManager
implements HotUpdateService {
    private static final Log log = LogFactory.getLog(HotUpdateManager.class);

    @Override
    public List<String> getMappigsPerWebapp(String webAppName) {
        try {
            return HostUtil.getMappingsPerWebApp(webAppName);
        }
        catch (UrlMapperException e) {
            log.error((Object)"error while retrieving from registry", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteHost(String webappName) {
        try {
            List<String> hostNames = HostUtil.getMappingsPerWebApp(webappName);
            for (String hostName : hostNames) {
                HostUtil.removeHost(hostName);
            }
        }
        catch (UrlMapperException e) {
            log.error((Object)("error while removing host for " + webappName), (Throwable)e);
        }
    }
}

