/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.ApplicationContext;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.tomcat.ext.valves.CarbonContextCreatorValve;
import org.wso2.carbon.tomcat.ext.valves.CompositeValve;
import org.wso2.carbon.url.mapper.data.MappingData;
import org.wso2.carbon.url.mapper.internal.exception.UrlMapperException;
import org.wso2.carbon.url.mapper.internal.registry.RegistryManager;
import org.wso2.carbon.url.mapper.internal.util.DataHolder;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class HostUtil {
    private static final Log log = LogFactory.getLog(HostUtil.class);
    private static RegistryManager registryManager = new RegistryManager();

    public static List<String> getMappingsPerWebApp(String webAppName) throws UrlMapperException {
        ArrayList<String> hostNames = new ArrayList<String>();
        try {
            MappingData[] mappings = HostUtil.getAllMappingsFromRegistry();
            if (mappings != null) {
                for (MappingData mapping : mappings) {
                    String hostName = mapping.getMappingName();
                    if (mapping.isServiceMapping() || !webAppName.equals(mapping.getUrl())) continue;
                    hostNames.add(hostName);
                }
            }
            return hostNames;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get url mappings for the webapp ", (Throwable)e);
            throw new UrlMapperException("Failed to get url mappings for the webapp " + webAppName, e);
        }
    }

    public static boolean isMappingExist(String mappingName) throws UrlMapperException {
        mappingName = mappingName + ".wso2.com";
        MappingData[] mappings = HostUtil.getAllMappingsFromRegistry();
        boolean isExist = false;
        if (mappings != null) {
            for (MappingData mapping : mappings) {
                if (!mappingName.equalsIgnoreCase(mapping.getMappingName())) continue;
                isExist = true;
            }
        }
        return isExist;
    }

    public static List<String> getAllHostsFromRegistry() throws UrlMapperException {
        ArrayList<String> allHosts = new ArrayList<String>();
        try {
            MappingData[] mappings = HostUtil.getAllMappingsFromRegistry();
            if (mappings != null) {
                for (MappingData mapping : mappings) {
                    String hostName = mapping.getMappingName().replace("/hostinfo/", "");
                    if (mapping.isServiceMapping()) continue;
                    allHosts.add(hostName);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get all hosts ", (Throwable)e);
            throw new UrlMapperException("Failed to get all hosts ", e);
        }
        return allHosts;
    }

    public static MappingData[] getAllMappingsFromRegistry() throws UrlMapperException {
        try {
            return registryManager.getAllMappingsFromRegistry();
        }
        catch (Exception e) {
            log.error((Object)"Failed to get all hosts ", (Throwable)e);
            throw new UrlMapperException("Failed to get all url mappings from the registry ", e);
        }
    }

    public static List<String> getMappingsPerEppr(String url) throws UrlMapperException {
        ArrayList<String> hostNames = new ArrayList<String>();
        if (HostUtil.isServiceURLPattern(url)) {
            url = HostUtil.getServiceEndpoint(url);
            try {
                MappingData[] mappings = HostUtil.getAllMappingsFromRegistry();
                if (mappings != null) {
                    for (MappingData mapping : mappings) {
                        String hostName = mapping.getMappingName();
                        if (!mapping.isServiceMapping() || !url.equals(mapping.getUrl())) continue;
                        hostNames.add(hostName);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to get url mappings for the webapp " + url), (Throwable)e);
                throw new UrlMapperException("Failed to get url mappings for the webapp " + url, e);
            }
        }
        return hostNames;
    }

    public static String getServiceNameForHost(String hostName) throws UrlMapperException {
        try {
            return registryManager.getServiceNameForHost(hostName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve the servicename from the host " + hostName), (Throwable)e);
            throw new UrlMapperException("Failed to retrieve the servicename from the host " + hostName, e);
        }
    }

    public static int getTenantIdForHost(String hostName) throws UrlMapperException {
        int tenantId;
        try {
            tenantId = -1234;
            String tenantDomain = registryManager.getTenantDomainForHost(hostName);
            TenantManager tenantManager = DataHolder.getInstance().getRealmService().getTenantManager();
            try {
                tenantId = tenantManager.getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                log.error((Object)"error in getting tenant id when adding host to tomcat engine", (Throwable)e);
                throw new UrlMapperException("error in getting tenant id when adding host to tomcat engine");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve the tenant domain from the host " + hostName), (Throwable)e);
            throw new UrlMapperException("Failed to retrieve the tenant domain from the host " + hostName, e);
        }
        return tenantId;
    }

    public static void addWebAppToHost(String hostName, String uri) throws UrlMapperException {
        String webAppPath;
        String webAppsDir;
        String tenantDomain;
        if (MultitenantUtils.getTenantDomainFromRequestURL((String)uri) != null) {
            int tenantId;
            tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)uri);
            TenantManager tenantManager = DataHolder.getInstance().getRealmService().getTenantManager();
            try {
                tenantId = tenantManager.getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                log.error((Object)"error in getting tenant id when adding host to tomcat engine", (Throwable)e);
                throw new UrlMapperException("error in getting tenant id when adding host to tomcat engine");
            }
            webAppsDir = CarbonUtils.getCarbonTenantsDirPath() + "/" + tenantId + "/" + "webapps" + "/";
            webAppPath = HostUtil.getWebappPath(webAppsDir, uri);
        } else {
            tenantDomain = "carbon.super";
            webAppsDir = CarbonUtils.getCarbonRepository() + "webapps" + "/";
            webAppPath = HostUtil.getWebappPath(webAppsDir, uri);
        }
        Host host = HostUtil.addHostToEngine(hostName, webAppsDir);
        try {
            DataHolder.getInstance().getCarbonTomcatService().addWebApp(host, "/", webAppPath);
            registryManager.addHostToRegistry(hostName, uri, tenantDomain);
            ApplicationContext.getCurrentApplicationContext().putUrlMappingForApplication(hostName, uri);
        }
        catch (Exception e) {
            log.error((Object)"error in adding the virtual host to tomcat engine", (Throwable)e);
            throw new UrlMapperException("error in adding the virtual host to tomcat engine");
        }
    }

    public static String getWebappPath(String webappsDir, String uri) {
        String webAppFile = HostUtil.getContextFromUri(uri) + ".war";
        String webAppPath = webappsDir + webAppFile;
        File warFile = new File(webAppPath);
        if (warFile.exists()) {
            return webAppPath;
        }
        webAppPath = webappsDir + HostUtil.getContextFromUri(uri);
        return webAppPath;
    }

    public static Host addHostToEngine(String hostName, String appBase) {
        String hostBaseDir = appBase;
        CarbonTomcatService carbonTomcatService = DataHolder.getInstance().getCarbonTomcatService();
        Engine engine = carbonTomcatService.getTomcat().getEngine();
        StandardHost host = new StandardHost();
        host.setAppBase(hostBaseDir);
        host.setName(hostName);
        host.setUnpackWARs(false);
        host.addValve((Valve)new CarbonContextCreatorValve());
        host.addValve((Valve)new CompositeValve());
        engine.addChild((Container)host);
        log.info((Object)("host added to the tomcat: " + host));
        return host;
    }

    public static void deleteHostDirectory(String hostName) {
        String filePath = CarbonUtils.getCarbonCatalinaHome() + "/" + hostName;
        File file = new File(filePath);
        if (file.isDirectory() && file.list().length == 0) {
            file.delete();
        }
    }

    public static void editHostInEngine(String webAppName, String newHost, String oldHost) throws UrlMapperException {
        HostUtil.removeHost(oldHost);
        HostUtil.addWebAppToHost(newHost, webAppName);
    }

    public static void removeHost(String hostName) throws UrlMapperException {
        Container[] hosts = DataHolder.getInstance().getCarbonTomcatService().getTomcat().getEngine().findChildren();
        CarbonTomcatService carbonTomcatService = DataHolder.getInstance().getCarbonTomcatService();
        Engine engine = carbonTomcatService.getTomcat().getEngine();
        for (Container host : hosts) {
            if (!host.getName().contains(hostName)) continue;
            try {
                Context context = (Context)host.findChild("/");
                if (!host.getState().isAvailable()) continue;
                if (context != null && context.getAvailable()) {
                    context.setRealm(null);
                    context.stop();
                    context.destroy();
                    log.info((Object)("Unloaded webapp from the host: " + host + " as the context of: " + context));
                }
                host.removeChild((Container)context);
                host.setRealm(null);
                host.stop();
                host.destroy();
                engine.removeChild(host);
                HostUtil.deleteResourceToRegistry(host.getName());
                ApplicationContext.getCurrentApplicationContext().removeUrlMappingMap(host.getName());
                log.info((Object)("Unloaded host from the engine: " + host));
                break;
            }
            catch (LifecycleException e) {
                throw new UrlMapperException("Error when removing host from tomcat engine." + host, e);
            }
        }
        HostUtil.deleteHostDirectory(hostName);
        try {
            registryManager.removeFromRegistry(hostName);
        }
        catch (Exception e) {
            log.error((Object)"error in adding the domain to the resitry", (Throwable)e);
            throw new UrlMapperException("error in adding the domain to the resitry", e);
        }
    }

    public static void addDomainToServiceEpr(String hostName, String url) throws UrlMapperException {
        String tenantDomain = "";
        if ("t".contains(url)) {
            tenantDomain = MultitenantUtils.getTenantDomainFromRequestURL((String)url);
        }
        if (HostUtil.isServiceURLPattern(url)) {
            url = HostUtil.getServiceEndpoint(url);
        }
        try {
            registryManager.addEprToRegistry(hostName, url, tenantDomain);
            ApplicationContext.getCurrentApplicationContext().putUrlMappingForApplication(hostName, url);
        }
        catch (Exception e) {
            log.error((Object)"error in adding the domain to the resitry", (Throwable)e);
            throw new UrlMapperException("error in adding the domain to the resitry");
        }
    }

    public static void updateEprToRegistry(String newHost, String oldHost) throws UrlMapperException {
        try {
            String epr = HostUtil.getServiceNameForHost(oldHost);
            HostUtil.deleteResourceToRegistry(oldHost);
            HostUtil.addDomainToServiceEpr(newHost, epr);
        }
        catch (Exception e) {
            log.error((Object)"error in updating the domain to the resitry", (Throwable)e);
            throw new UrlMapperException("error in updating the domain to the resitry");
        }
    }

    public static void deleteResourceToRegistry(String host) throws UrlMapperException {
        try {
            registryManager.removeFromRegistry(host);
            ApplicationContext.getCurrentApplicationContext().removeUrlMappingMap(host);
        }
        catch (Exception e) {
            log.error((Object)"error in removing the domain to the resitry", (Throwable)e);
            throw new UrlMapperException("error in updating the domain to the resitry");
        }
    }

    public static String getContextFromUri(String uri) {
        String[] temp = uri.split("/");
        return temp[temp.length - 1];
    }

    public static String getServiceEndpoint(String url) throws UrlMapperException {
        String[] str = url.split("\\/services");
        if (str.length > 1) {
            return str[1];
        }
        throw new UrlMapperException("Invalid End point URL");
    }

    public static boolean isServiceURLPattern(String url) {
        Pattern pattern = Pattern.compile("\\/services");
        Matcher matcher = pattern.matcher(url);
        return matcher.find();
    }

    public static boolean isValidHost(String domain) throws UrlMapperException {
        try {
            MappingData[] mappings = HostUtil.getAllMappingsFromRegistry();
            if (mappings != null) {
                for (MappingData mapping : mappings) {
                    String hostName = mapping.getMappingName().substring("/hostinfo/".length());
                    if (!hostName.equals(domain)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed validating the endpoint domain " + domain), (Throwable)e);
            throw new UrlMapperException("Failed validating the endpoint domain " + domain, e);
        }
        return false;
    }
}

