/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.url.mapper.internal.registry;

import java.util.ArrayList;
import org.apache.catalina.Host;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.url.mapper.data.MappingData;
import org.wso2.carbon.url.mapper.internal.util.DataHolder;

public class RegistryManager {
    private static Log log = LogFactory.getLog(RegistryManager.class);
    private static Registry registryService = DataHolder.getInstance().getRegistry();

    public void addHostToRegistry(String hostName, String webApp, String tenantDomain) throws Exception {
        try {
            registryService.beginTransaction();
            Resource hostResource = registryService.newResource();
            hostResource.addProperty("host.name", hostName);
            hostResource.addProperty("web.app", webApp);
            hostResource.addProperty("tenant.domain", tenantDomain);
            registryService.put("hostinfo/" + hostName, hostResource);
            registryService.commitTransaction();
        }
        catch (Exception e) {
            registryService.rollbackTransaction();
            log.error((Object)"Unable to add the host", (Throwable)e);
            throw e;
        }
    }

    public void addEprToRegistry(String hostName, String webApp, String tenantDomain) throws Exception {
        try {
            registryService.beginTransaction();
            Resource hostResource = registryService.newResource();
            hostResource.addProperty("host.name", hostName);
            hostResource.addProperty("service.epr", webApp);
            hostResource.addProperty("tenant.domain", tenantDomain);
            registryService.put("hostinfo/" + hostName, hostResource);
            registryService.commitTransaction();
        }
        catch (Exception e) {
            registryService.rollbackTransaction();
            log.error((Object)"Unable to add the host", (Throwable)e);
            throw e;
        }
    }

    public void updateHostToRegistry(Host host, String webApp) throws Exception {
        try {
            registryService.beginTransaction();
            String hostResourcePath = "hostinfo/" + host.getName();
            if (registryService.resourceExists(hostResourcePath)) {
                Resource hostResource = registryService.get(hostResourcePath);
                hostResource.setProperty("host.name", host.getName());
                hostResource.setProperty("web.app", webApp);
                registryService.put("hostinfo/" + host.getName(), hostResource);
            } else {
                Resource hostResource = registryService.newResource();
                hostResource.addProperty("host.name", host.getName());
                hostResource.addProperty("web.app", webApp);
                registryService.put("hostinfo/" + host.getName(), hostResource);
            }
            registryService.commitTransaction();
        }
        catch (Exception e) {
            registryService.rollbackTransaction();
            log.error((Object)"Unable to update the host", (Throwable)e);
            throw e;
        }
    }

    public void removeFromRegistry(String hostName) throws Exception {
        try {
            registryService.beginTransaction();
            String hostResourcePath = "hostinfo/" + hostName;
            if (registryService.resourceExists(hostResourcePath)) {
                registryService.delete(hostResourcePath);
            }
            registryService.commitTransaction();
        }
        catch (Exception e) {
            registryService.rollbackTransaction();
            log.error((Object)"Unable to remove the host", (Throwable)e);
            throw e;
        }
    }

    public Resource getMappingFromRegistry(String hostName) throws Exception {
        String hostResourcePath = "hostinfo/" + hostName;
        if (registryService.resourceExists(hostResourcePath)) {
            return registryService.get(hostResourcePath);
        }
        return null;
    }

    public String getWebAppNameForHost(String hostName) throws Exception {
        Resource resource = this.getMappingFromRegistry(hostName);
        if (resource != null) {
            return resource.getProperty("web.app");
        }
        return null;
    }

    public String getServiceNameForHost(String hostName) throws Exception {
        Resource resource = this.getMappingFromRegistry(hostName);
        if (resource != null) {
            return resource.getProperty("service.epr");
        }
        return null;
    }

    public String getTenantDomainForHost(String hostName) throws Exception {
        Resource resource = this.getMappingFromRegistry(hostName);
        if (resource != null) {
            return resource.getProperty("tenant.domain");
        }
        return null;
    }

    public MappingData[] getAllMappingsFromRegistry() throws Exception {
        Collection mappings = this.getHostsFromRegistry();
        ArrayList<MappingData> mappingList = new ArrayList<MappingData>();
        if (mappings != null) {
            String[] mappingNames;
            for (String mappingName : mappingNames = mappings.getChildren()) {
                Resource resource = this.getMappingFromRegistry(mappingName = mappingName.replace("/hostinfo/", ""));
                if (resource == null) continue;
                MappingData mappingData = new MappingData();
                mappingData.setMappingName(resource.getProperty("host.name"));
                mappingData.setTenantDomain(resource.getProperty("tenant.domain"));
                if (resource.getProperty("service.epr") != null) {
                    mappingData.setServiceMapping(true);
                    mappingData.setUrl(resource.getProperty("service.epr"));
                } else {
                    mappingData.setUrl(resource.getProperty("web.app"));
                }
                mappingList.add(mappingData);
            }
            return mappingList.toArray(new MappingData[mappingList.size()]);
        }
        return null;
    }

    private Collection getHostsFromRegistry() throws Exception {
        if (registryService.resourceExists("hostinfo/")) {
            return (Collection)registryService.get("hostinfo/");
        }
        return null;
    }
}

